# Practitioner-123456789 - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Practitioner-123456789**

## Example Practitioner: Practitioner-123456789

Profile: [Practitioner (CZ core)](StructureDefinition-cz-practitioner-core.md)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/krzp`/123456789

**name**: Švejk Josef 

**telecom**: [+420 603 853 227](tel:+420603853227)

**address**: Rovná 11, 160 00, Praha 6(work)

**gender**: Male

**birthDate**: 1965-05-11

**communication**: Czech



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "Practitioner-123456789",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
      "value" : "123456789"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Josef",
      "given" : ["Švejk"],
      "prefix" : ["MUDr."],
      "suffix" : ["PhD."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 603 853 227",
      "use" : "home"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "both",
      "text" : "Rovná 11, 160 00, Praha 6",
      "line" : ["Rovná 12", null],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Rovná"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "11"
            }
          ]
        }
      ],
      "city" : "Praha 6",
      "postalCode" : "16000",
      "country" : "CZ"
    }
  ],
  "gender" : "male",
  "birthDate" : "1965-05-11",
  "communication" : [
    {
      "coding" : [
        {
          "system" : "urn:ietf:bcp:47",
          "code" : "cs"
        }
      ]
    }
  ]
}

```
