# cz-patient-addr-example-5 - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **cz-patient-addr-example-5**

## Example Patient: cz-patient-addr-example-5

Profile: [Patient (CZ core)](StructureDefinition-cz-patient-core.md)

Adam Příklad (no stated gender), DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rid#4567891237)

-------

| | |
| :--- | :--- |
| Contact Detail | Malé náměstí 13a, 150 00, Praha 5(home) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "cz-patient-addr-example-5",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "4567891237"
    }
  ],
  "name" : [
    {
      "family" : "Příklad",
      "given" : ["Adam"]
    }
  ],
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://hl7.cz/fhir/core/StructureDefinition/address-point-cz",
          "valueIdentifier" : {
            "system" : "https://ncez.mzcr.cz/fhir/sid/ruian",
            "value" : "27318508"
          }
        }
      ],
      "use" : "home",
      "type" : "both",
      "text" : "Malé náměstí 13a, 150 00, Praha 5",
      "line" : ["Malé náměstí 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "Česká republika",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ]
}

```
