# cz-patient-addr-example-2 - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **cz-patient-addr-example-2**

## Example Patient: cz-patient-addr-example-2

Profile: [Patient (CZ core)](StructureDefinition-cz-patient-core.md)

Adam Příklad (no stated gender), DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rid#4567891237)

-------

| | |
| :--- | :--- |
| Contact Detail | P.O.Box 123, 150 00, Praha 5 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "cz-patient-addr-example-2",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "4567891237"
    }
  ],
  "name" : [
    {
      "family" : "Příklad",
      "given" : ["Adam"]
    }
  ],
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "type" : "postal",
      "text" : "P.O.Box 123, 150 00, Praha 5",
      "line" : ["P.O.Box 123"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox",
              "valueString" : "123"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ]
}

```
