# Mracena - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Mracena**

## Example Patient: Mracena

Profile: [Patient (CZ core)](StructureDefinition-cz-patient-core.md)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))

-------

| | |
| :--- | :--- |
| Other Ids: | * `https://ncez.mzcr.cz/fhir/sid/rcis`/7161264528 (use: official, )
* `https://ncez.mzcr.cz/fhir/sid/rid`/2066425387
* Passport number/23476533 (use: official, )
 |
| Contact Detail | * [+420 603 853 227](tel:+420603853227)
* Malé náměstí 13a, 150 00, Praha 5(home)
 |
| Languages: | * Czech (preferred)
* English
* German
 |
| matka: | * Biologická Matka Mrakomorová 
* [+420 604 123 456](tel:+420604123456)
 |
| přítel/přítelkyně: | * Alena Dlouhá 
* Horná ulica 18, 123 45, Trenčín, Slovensko(home)
* [+420 601 111 111](tel:+420601111111)
 |
| Links: | * General Practitioner: MUDr. Josef Švejk (Identifier: `https://ncez.mzcr.cz/fhir/sid/krzp`/123456789)
 |
| Patient Nationality: | * code: Czechia
 |
| Registering provider: | * value: [Organization MUDr. Hana Doktorová](#hcMracena/RegisteringProviderExample)
* category: General medical service
 |
| Registering provider: | * value: [Organization MUDr. Hana Doktorová](#hcMracena/RegisteringProviderExample)
* category: Gynecology service
 |

-------

**Contained Resource**

-------

Profile: [Organization (CZ core)](StructureDefinition-cz-organization-core.md)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/ico`/456789655

**type**: Samost. ordinace všeob. prakt. lékaře

**name**: MUDr. Hana Doktorová



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "Mracena",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Organization",
      "id" : "RegisteringProviderExample",
      "meta" : {
        "profile" : [
          "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
        ]
      },
      "identifier" : [
        {
          "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
          "value" : "456789655"
        }
      ],
      "type" : [
        {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-drzar",
              "code" : "320",
              "display" : "Samost. ordinace všeob. prakt. lékaře"
            }
          ]
        }
      ],
      "name" : "MUDr. Hana Doktorová"
    }
  ],
  "extension" : [
    {
      "extension" : [
        {
          "url" : "code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "CZ"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueReference" : {
            "reference" : "#RegisteringProviderExample"
          }
        },
        {
          "url" : "category",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "version" : "http://snomed.info/sct/11000279109",
                "code" : "700232004",
                "display" : "General medical service"
              }
            ]
          }
        }
      ],
      "url" : "https://hl7.cz/fhir/core/StructureDefinition/registering-provider-cz"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueReference" : {
            "reference" : "#RegisteringProviderExample"
          }
        },
        {
          "url" : "category",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "version" : "http://snomed.info/sct/11000279109",
                "code" : "310061009",
                "display" : "Gynecology service"
              }
            ]
          }
        }
      ],
      "url" : "https://hl7.cz/fhir/core/StructureDefinition/registering-provider-cz"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "7161264528"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "2066425387"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/NamingSystem/passportNumNS-CZE",
      "value" : "23476533",
      "assigner" : {
        "display" : "Ministerstvo vnitra České republiky"
      }
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/NamingSystem/passportNumNS-SVK",
      "value" : "88476522"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 603 853 227",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Malé náměstí 13a, 150 00, Praha 5",
      "line" : ["Malé náměstí 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "CZ",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "MTH",
              "display" : "matka"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N",
              "display" : "Příbuzný"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Mrakomorová",
        "given" : ["Biologická", "Matka"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+420 604 123 456",
          "use" : "mobile"
        }
      ]
    },
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "FRND",
              "display" : "přítel/přítelkyně"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "C",
              "display" : "Emergentní kontakt"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Dlouhá",
        "given" : ["Alena"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+420 601 111 111",
          "use" : "home"
        }
      ],
      "address" : {
        "use" : "home",
        "type" : "physical",
        "text" : "Horná ulica 18, 123 45, Trenčín, Slovensko",
        "line" : ["Horná ulica 18"],
        "_line" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                "valueString" : "Horná ulica"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                "valueString" : "18"
              }
            ]
          }
        ],
        "city" : "Trenčín",
        "postalCode" : "12345",
        "country" : "Slovensko",
        "_country" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
              "valueCoding" : {
                "system" : "urn:iso:std:iso:3166",
                "code" : "SK",
                "display" : "Slovakia"
              }
            }
          ]
        }
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "de"
          }
        ]
      }
    }
  ],
  "generalPractitioner" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
        "value" : "123456789"
      },
      "display" : "MUDr. Josef Švejk"
    }
  ]
}

```
