# Medication - Simvastatin 40 MG Disintegrating Oral Tablet - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Medication - Simvastatin 40 MG Disintegrating Oral Tablet**

## Example Medication: Medication - Simvastatin 40 MG Disintegrating Oral Tablet

Profile: [Medication (CZ)](StructureDefinition-cz-Medication.md)

**identifier**: `http://example.org/exampleSystem`/med-1

**code**: Simvastatin 40 MG TBL FLM 20

**form**: Potahovaná tableta

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Item[x]** | **Strength** |
| * | Simvastatin | 40 mcg(Details: UCUM codemg = 'mg')/1 tablet(Details: UCUM code1 = '1') |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "med-1",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
  },
  "identifier" : [
    {
      "system" : "http://example.org/exampleSystem",
      "value" : "med-1"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://sukl.cz/terminology/CodeSystem/dlp-lecive-pripravky",
        "code" : "0013831",
        "display" : "SIMVASTATIN RATIOPHARM 40MG TBL FLM 20"
      },
      {
        "system" : "https://sukl.cz/terminology/CodeSystem/dlp-atc",
        "code" : "C10AA01",
        "display" : "simvastatin"
      }
    ],
    "text" : "Simvastatin 40 MG TBL FLM 20"
  },
  "form" : {
    "coding" : [
      {
        "system" : "https://sukl.cz/terminology/CodeSystem/dlp-formy",
        "code" : "TBL_FLM",
        "display" : "Potahovaná tableta"
      },
      {
        "system" : "http://standardterms.edqm.eu",
        "code" : "10219000",
        "display" : "Tablet"
      }
    ]
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sukl.cz/terminology/CodeSystem/dlp-lecivelatky",
            "code" : "10647",
            "display" : "Simvastatin"
          }
        ]
      },
      "strength" : {
        "numerator" : {
          "value" : 40,
          "unit" : "mcg",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "tablet",
          "system" : "http://unitsofmeasure.org",
          "code" : "1"
        }
      }
    }
  ]
}

```
