# cz-encounter-example - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **cz-encounter-example**

## Example Encounter: cz-encounter-example

Profile: [Encounter (CZ)](StructureDefinition-cz-encounter.md)

**identifier**: `http://example.org/hospital`/ku-123456789

**status**: In Progress

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**type**: Rentgen pacienta XY

**serviceProvider**: [Organization MUDr. Hana Doktorová](Organization-Organization-2.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "cz-encounter-example",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"]
  },
  "identifier" : [
    {
      "system" : "http://example.org/hospital",
      "value" : "ku-123456789"
    }
  ],
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB"
  },
  "type" : [
    {
      "text" : "Rentgen pacienta XY"
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/Organization-2"
  }
}

```
