# Pacemaker - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Pacemaker**

## Example Device: Pacemaker

Profile: [Medical Device (CZ)](StructureDefinition-cz-medical-device.md)

**manufacturer**: Medtronic

**modelNumber**: W1DR01

**type**: Cardiac pacemaker

**patient**: [Pokusný Pacient](Patient-Mracena.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "Pacemaker",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
    ]
  },
  "manufacturer" : "Medtronic",
  "modelNumber" : "W1DR01",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000279109",
        "code" : "14106009",
        "display" : "Cardiac pacemaker"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena",
    "display" : "Pokusný Pacient"
  }
}

```
