# Body structure Example - HL7 Czech Base and Core Implementation Guide v0.3.0-ballot

* [**Table of Contents**](toc.md)
* [**Summary artifacts**](artifacts.md)
* **Body structure Example**

## Example BodyStructure: Body structure Example

Profile: [Body Structure (CZ)](StructureDefinition-BodyStructure-cz.md)

**Extension Definition for BodyStructure.includedStructure.laterality for Version 5.0**: Right

**morphology**: Bite

**location**: Scapular region of back

**locationQualifier**: RUQ - Right upper quadrant

**description**: Canis lupus familiaris viděl na zádech poraněného sedět Musca domestica a při útoku na ni došlo k neúmyslnému pokousání

**patient**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena.md)



## Resource Content

```json
{
  "resourceType" : "BodyStructure",
  "id" : "BodyStructure01",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-BodyStructure.includedStructure.laterality",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/11000279109",
            "code" : "24028007",
            "display" : "Right"
          }
        ]
      }
    }
  ],
  "morphology" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000279109",
        "code" : "3404009",
        "display" : "Bite"
      }
    ]
  },
  "location" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000279109",
        "code" : "7874003",
        "display" : "Scapular region of back"
      }
    ]
  },
  "locationQualifier" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000279109",
          "code" : "255497008",
          "display" : "RUQ - Right upper quadrant"
        }
      ]
    }
  ],
  "description" : "Canis lupus familiaris viděl na zádech poraněného sedět Musca domestica a při útoku na ni došlo k neúmyslnému pokousání",
  "patient" : {
    "reference" : "Patient/Mracena"
  }
}

```
