# hl7.fhir.cz.amb#0.1.0: HL7 Czech Outpatient Encounter Report Implementation Guide

## Pages

* [Home](index.md)
* [Background](background-cs.md)
* [Mapping of EncounterCourse](EncounterCourse-map.md)
* [Authors](authors.md)
* [Mapping of Alerts](Alerts-map.md)
* [Dependencies](dependencies.md)
* [Oblasti a obsah](scope-and-content-cs.md)
* [Autorská práva](copyright-cs.md)
* [Mapping of MedicationSummary](MedicationSummary-map.md)
* [Mapping of OutpatientEncounterReport](OutpatientEncounterReport-map.md)
* [Mapování logického modelu](model-map-cs.md)
* [Mapping of AmbulatoryEncounterInformation](AmbulatoryEncounterInformation-map.md)
* [Copyright](copyright.md)
* [Obligations](obligations-cs.md)
* [Závislosti](dependencies-cs.md)
* [Examples](examples.md)
* [Model maps](model-map.md)
* [Mapping of InPatientEncounter](InPatientEncounter-map.md)
* [Mapping of PatientHistory](PatientHistory-map.md)
* [Mapping of PresentedForm](PresentedForm-map.md)
* [Downloads](downloads.md)
* [Logical models](logical-models.md)
* [Background](background.md)
* [Implementation notes](implementation-notes.md)
* [Mapping of Attachments](Attachements-map.md)
* [Scope and content](scope-and-content.md)
* [Datová sada - logické modely CZ](logical-models-cs.md)
* [Obligations](obligations.md)
* [Autoři](authors-cs.md)
* [Mapping of Header](Header-map.md)
* [Mapping of CarePlan](CarePlan-map.md)
* [Implementační poznámky](implementation-notes-cs.md)
* [Příklady](examples-cs.md)
* [Artifacts Summary](artifacts.md)
* [Ke stažení](downloads-cs.md)
* [Mapping of AdvanceDirectives](AdvanceDirectives-map.md)

## Resources

### Logicals

* [A.2.4 - Admission Evaluation](StructureDefinition-AdmissionEvaluationCz.md)
* [A.2.1 - Advance Directives](StructureDefinition-AdvanceDirectivesCz.md)
* [A.2.2 - Alerts](StructureDefinition-AlertsCz.md)
* [A.4 - Attachments](StructureDefinition-AttachmentsCz.md)
* [A.2.3 - Encounter](StructureDefinition-EncounterCz.md)
* [A.1 - Header](StructureDefinition-HeaderAmbCz.md)
* [A.1.1 - Identifikace a A.1.2 - informace o pacientovi](StructureDefinition-LogSubjectCz.md)
* [A.1.9 - Digitální podpis](StructureDefinition-LogdigitalSignatureCz.md)
* [A.2.8 - Medication Summary](StructureDefinition-MedicationSummaryCz.md)
* [A - Outpatient Encounter Report](StructureDefinition-OutpatientEncounterReportCz.md)
* [A.2.7 - Outpatient stay](StructureDefinition-OutpatientStayCz.md)
* [A.2.6 - Patient History](StructureDefinition-PatientHistoryCz.md)
* [A.2.9.1 - Plan of Care](StructureDefinition-PlanOfCareCz.md)
* [A.3 - Presented Form](StructureDefinition-PresentedFormCz.md)
* [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md)
* [A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md)
* [A.2.4 - Stav při přijetí](StructureDefinition-logAdmissionEvaluationCz.md)
* [A.2.1 - Dříve vyslovená přání](StructureDefinition-logAdvanceDirectivesCz.md)
* [A.2.2 - Urgentní informace](StructureDefinition-logAlertsCz.md)
* [A.4 - Ostatní přílohy](StructureDefinition-logAttachmentsCz.md)
* [A.2.3 - Údaje o ambulantním kontaktu](StructureDefinition-logEncounterCz.md)
* [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderAmbCz.md)
* [A.2.8 - Souhrn medikace](StructureDefinition-logMedicationSummaryCz.md)
* [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)
* [A.2.7 - Průběh ambulantního kontaktu](StructureDefinition-logOutpatientStayCz.md)
* [A.2.6 - Anamnéza pacienta](StructureDefinition-logPatientHistoryCz.md)
* [A.2.9.1 - Plán péče](StructureDefinition-logPlanOfCareCz.md)
* [A.3 - Prezentační forma](StructureDefinition-logPresentedFormCz.md)

### Resource Profiles

* [AllergyIntolerance: Outpatient Encounter Report (CZ)](StructureDefinition-cz-allergyintolerance-amb.md)
* [Bundle Outpatient Encounter Report (CZ)](StructureDefinition-cz-bundle-amb.md)
* [Composition: Outpatient Encounter Report (CZ)](StructureDefinition-cz-composition-amb.md)
* [Encounter (AMB CZ)](StructureDefinition-cz-encounter-amb.md)
* [Flag: Outpatient Encounter Report (CZ)](StructureDefinition-cz-flag-amb.md)
* [Flag Obligations (AMB CZ)](StructureDefinition-cz-flag-obl-amb.md)

### ConceptMaps

* [CZ Admition Evaluation Model to this guide Map](ConceptMap-admitionEvaluation2FHIR-cz-amb.md)
* [CZ Advance Directives Model to this guide Map](ConceptMap-advanceDirectives2FHIR-cz-amb.md)
* [CZ Alerts Model to this guide Map](ConceptMap-alerts2FHIR-cz-amb.md)
* [CZ Attachement Model to this guide Map](ConceptMap-attachement2FHIR-cz-amb.md)
* [CZ Encounter Model to this guide Map](ConceptMap-encounter2FHIR-cz-amb.md)
* [CZ Header Model to this guide Map](ConceptMap-header2FHIR-cz-amb.md)
* [CZ Medication Summary Model to this guide Map](ConceptMap-medicationSummary2FHIR-cz-amb.md)
* [CZ Patient History Model to this guide Map](ConceptMap-patientHistory2FHIR-cz-amb.md)
* [CZ Patient Stay Model to this guide Map](ConceptMap-patientStay2FHIR-cz-amb.md)
* [CZ Plan of Care Model to this guide Map](ConceptMap-planOfCare2FHIR-cz-amb.md)
* [CZ Presented Form Model to this guide Map](ConceptMap-presentedForm2FHIR-cz-amb.md)

### ImplementationGuides

* [HL7 Czech Outpatient Encounter Report Implementation Guide](index.md)

### Examples

* [OutpatientBundle-Mracena (Bundle)](Bundle-OutpatientBundle-Mracena.md)
* [Ambulantní zpráva (Composition)](Composition-698056a8-57a6-49ed-909e-ea4216b18a6d.md)
* [00d304b8-5839-43dd-9239-69aed544f7e1 (Patient)](Patient-00d304b8-5839-43dd-9239-69aed544f7e1.md)
* [161dcf7e-928b-437a-a310-6c61038e6ff9 (Practitioner)](Practitioner-161dcf7e-928b-437a-a310-6c61038e6ff9.md)
