# Home - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ImplementationGuide/hl7.fhir.cz.amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:HL7CzAmbEncounterReportImplementationGuide |

### Introduction

This implementation guide specifies a set of rules to be applied to HL7 FHIR to define **Outpatient Encounter Report** (or any kind of similar encounter) in the Czech national context.

Its main objective is to define the content components and the preferred structure to be used. The purpose of this standard is to define the representation of the discharge report as a patient's medical record for the purpose of electronic exchange between individuals, healthcare providers and infrastructure components in the Czech Republic.

This includes both national and cross-border scenarios.

### Scope

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction, scope short, references, dependencies, cross version analysis and IP statement for this guide.
* Introduction: 
* [Scope and content](scope-and-content.md): This segment contains general information about Imaging report.
* [Background](background.md): This segment contains background information about Imaging report.
 
* Functional: 
* [Use cases](use-cases.md): This segment contains information about use cases.
* [Workflow](workflow.md): This segment contains information about workflow.
* [Logical models](logical-models.md): This segment contains information about logical models.
* [Terminology considerations](terminology-considerations.md): This segment contains information about terminology.
 
* Implementation: 
* [Mapping to profiles](model-map.md): This segment contains information about logical model maps to profiles.
* [Examples](examples.md): This segment contains information about examples.
* [Obligations](obligations.md): This segment contains information about obligations.
* [Implementation notes](implementation-notes.md): This segment contains information for implementation.
 
* About: 
* [Authors](authors.md): This segment contains informaction about authors.
* [Downloads](downloads.md): This segment contains informaction about downloads.
* [Dependencies](dependencies.md): This segment contains informaction about dependencies.
* [Copyright](copyright.md): This segment contains informaction about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Dependencies
























### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.amb.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.amb.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AdmitionEvaluation2FHIRCzAmb](ConceptMap-admitionEvaluation2FHIR-cz-amb.md), [AdvanceDirectives2FHIRCzAmb](ConceptMap-advanceDirectives2FHIR-cz-amb.md)... Show 44 more, [Alerts2FHIRCzAmb](ConceptMap-alerts2FHIR-cz-amb.md), [Attachement2FHIRCzAmb](ConceptMap-attachement2FHIR-cz-amb.md), [CZ_AllergyIntoleranceAmb](StructureDefinition-cz-allergyintolerance-amb.md), [CZ_BundleAmb](StructureDefinition-cz-bundle-amb.md), [CZ_CompositionAmb](StructureDefinition-cz-composition-amb.md), [CZ_EncounterAmb](StructureDefinition-cz-encounter-amb.md), [CZ_FlagAmb](StructureDefinition-cz-flag-amb.md), [CZ_FlagObligationsAmb](StructureDefinition-cz-flag-obl-amb.md), [Encounter2FHIRCzAmb](ConceptMap-encounter2FHIR-cz-amb.md), [HL7CzAmbEncounterReportImplementationGuide](index.md), [Header2FHIRCzAmb](ConceptMap-header2FHIR-cz-amb.md), [LogCzAdmissionEvaluationCz](StructureDefinition-logAdmissionEvaluationCz.md), [LogCzAdvanceDirectivesCz](StructureDefinition-logAdvanceDirectivesCz.md), [LogCzAlertsCz](StructureDefinition-logAlertsCz.md), [LogCzAttachmentsCz](StructureDefinition-logAttachmentsCz.md), [LogCzDigitalSignatureCz](StructureDefinition-LogdigitalSignatureCz.md), [LogCzEncounterCz](StructureDefinition-logEncounterCz.md), [LogCzHeaderAmbCz](StructureDefinition-logHeaderAmbCz.md), [LogCzMedicationSummaryCz](StructureDefinition-logMedicationSummaryCz.md), [LogCzOutpatientEncounterReportCz](StructureDefinition-logOutpatientEncounterReportCz.md), [LogCzOutpatientStayCz](StructureDefinition-logOutpatientStayCz.md), [LogCzPatientHistoryCz](StructureDefinition-logPatientHistoryCz.md), [LogCzPlanOfCareCz](StructureDefinition-logPlanOfCareCz.md), [LogCzPresentedFormCz](StructureDefinition-logPresentedFormCz.md), [LogCzSubjectHdrCz](StructureDefinition-LogSubjectCz.md), [LogEnAdmissionEvaluationCz](StructureDefinition-AdmissionEvaluationCz.md), [LogEnAdvanceDirectivesCz](StructureDefinition-AdvanceDirectivesCz.md), [LogEnAlertsCz](StructureDefinition-AlertsCz.md), [LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md), [LogEnDigitalSignatureCz](StructureDefinition-digitalSignatureCz.md), [LogEnEncounterCz](StructureDefinition-EncounterCz.md), [LogEnHeaderAmbCz](StructureDefinition-HeaderAmbCz.md), [LogEnMedicationSummaryCz](StructureDefinition-MedicationSummaryCz.md), [LogEnOutpatientEncounterReportCz](StructureDefinition-OutpatientEncounterReportCz.md), [LogEnOutpatientStayCz](StructureDefinition-OutpatientStayCz.md), [LogEnPatientHistoryCz](StructureDefinition-PatientHistoryCz.md), [LogEnPlanOfCareCz](StructureDefinition-PlanOfCareCz.md), [LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md), [LogEnSubjectHdrEhnCz](StructureDefinition-SubjectCz.md), [MedicationSummary2FHIRCzAmb](ConceptMap-medicationSummary2FHIR-cz-amb.md), [PatientHistory2FHIRCzAmb](ConceptMap-patientHistory2FHIR-cz-amb.md), [PatientStay2FHIRCzAmb](ConceptMap-patientStay2FHIR-cz-amb.md), [PlanOfCare2FHIRCzAmb](ConceptMap-planOfCare2FHIR-cz-amb.md) and [PresentedForm2FHIRCzAmb](ConceptMap-presentedForm2FHIR-cz-amb.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/OutpatientBundle-Mracena](Bundle-OutpatientBundle-Mracena.md), [CZ_CompositionAmb](StructureDefinition-cz-composition-amb.md) and [Composition/698056a8-57a6-49ed-909e-ea4216b18a6d](Composition-698056a8-57a6-49ed-909e-ea4216b18a6d.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Bundle/OutpatientBundle-Mracena](Bundle-OutpatientBundle-Mracena.md) and [Patient/00d304b8-5839-43dd-9239-69aed544f7e1](Patient-00d304b8-5839-43dd-9239-69aed544f7e1.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [CZ_EncounterAmb](StructureDefinition-cz-encounter-amb.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [CZ_EncounterAmb](StructureDefinition-cz-encounter-amb.md)


