# A.2.6 - Anamnéza pacienta - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.6 - Anamnéza pacienta**

## Logical Model: A.2.6 - Anamnéza pacienta 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logPatientHistoryCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzPatientHistoryCz |

 
Anamnéza pacienta 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logPatientHistoryCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logPatientHistoryCz.csv), [Excel](StructureDefinition-logPatientHistoryCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logPatientHistoryCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logPatientHistoryCz",
  "version" : "0.1.0",
  "name" : "LogCzPatientHistoryCz",
  "title" : "A.2.6 - Anamnéza pacienta",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Anamnéza pacienta",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logPatientHistoryCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logPatientHistoryCz",
        "path" : "logPatientHistoryCz",
        "short" : "A.2.6 - Anamnéza pacienta",
        "definition" : "Anamnéza pacienta"
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni",
        "path" : "logPatientHistoryCz.anamnezaOsobni",
        "short" : "A.2.6.1 - Osobní",
        "definition" : "Osobní Anamnéza",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy",
        "short" : "A.2.6.1.1 - Historie zdravotních problémů",
        "definition" : "Historie zdravotních problémů jiných, než je nynější onemocnění (které je součástí klinického shrnutí).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.popisProblemu",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.popisProblemu",
        "short" : "A.2.6.1.1.1 - Popis problému",
        "definition" : "Popis problému textem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.kod",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.kod",
        "short" : "A.2.6.1.1.2 - Kód",
        "definition" : "Formalizované vyjádření zdravotního problému kódem (klasifikace).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVzniku",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVzniku",
        "short" : "A.2.6.1.1.3 - Datum vzniku",
        "definition" : "Datum či částečné datum případně věková kategorie vzniku onemocnění",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVyreseni",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVyreseni",
        "short" : "A.2.6.1.1.4 - Datum vyřešení či remise",
        "definition" : "Datum či částečné datum případně věková kategorie vyřešení či ustoupení problému do remise. Problémy jejichž klinický stav je \"aktivní\" nemají tento údaj vyplněn.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.klinickyStav",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.klinickyStav",
        "short" : "A.2.6.1.1.5 - Klinický stav problému",
        "definition" : "Klasifikace klinického stavu problému (aktivní, neaktivní).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.okolnostiVyreseni",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.okolnostiVyreseni",
        "short" : "A.2.6.1.1.6 - Okolnosti vyřešení",
        "definition" : "Důvod, pro který se stav problému změnil na neaktivní...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.zavaznost",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.zavaznost",
        "short" : "A.2.6.1.1.7 - Závažnost",
        "definition" : "Subjektivní hodnocení závažnosti problému klinikem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.stadiumOnemocneni",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.stadiumOnemocneni",
        "short" : "A.2.6.1.1.8 - Stadium onemocnění",
        "definition" : "Stadium/grading problému dle zvolené škály textem a/nebo kódem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zP",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zP",
        "short" : "A.2.6.1.2 - Historie zdravotních pomůcek a implantátů",
        "definition" : "Historie implantátů a zdravotních pomůcek...",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zP.popis",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zP.popis",
        "short" : "A.2.6.1.2.1 - Popis zdravotnického prostředku",
        "definition" : "Popis zdravotnického prostředku...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zP.idZP",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zP.idZP",
        "short" : "A.2.6.1.2.2 - Identifikátor zdravotnického prostředku",
        "definition" : "Normalizovaný identifikátor...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zP.datumZavedeni",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zP.datumZavedeni",
        "short" : "A.2.6.1.2.3 - Datum zavedení",
        "definition" : "Datum implantace...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zP.datumOdstraneni",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zP.datumOdstraneni",
        "short" : "A.2.6.1.2.4 - Datum odstranění",
        "definition" : "Datum explantace...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.zP.duvod",
        "path" : "logPatientHistoryCz.anamnezaOsobni.zP.duvod",
        "short" : "A.2.6.1.2.5 - Důvod použití",
        "definition" : "Klinický důvod zavedení...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony",
        "short" : "A.2.6.1.3 - Významné výkony",
        "definition" : "Významné výkony...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.kodVykonu",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.kodVykonu",
        "short" : "A.2.6.1.3.1 - Kód výkonu",
        "definition" : "Kód výkonu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.popis",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.popis",
        "short" : "A.2.6.1.3.2 - Popis procedury",
        "definition" : "Popis výkonu volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.lokalizace",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.lokalizace",
        "short" : "A.2.6.1.3.3 - Lokalizace",
        "definition" : "Anatomická lokace...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.datum",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.datum",
        "short" : "A.2.6.1.3.4 - Datum provedení",
        "definition" : "Datum provedení výkonu...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.duvod",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.duvod",
        "short" : "A.2.6.1.3.5 - Důvod provedení",
        "definition" : "Důvod provedení výkonu...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.vysledek",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.vysledek",
        "short" : "A.2.6.1.3.6 - Výsledek",
        "definition" : "Formalizované vyjádření výsledku výkonu...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.pouzityZP",
        "path" : "logPatientHistoryCz.anamnezaOsobni.vyznamneVykony.pouzityZP",
        "short" : "A.2.6.1.3.7 - Použitý zdravotnický prostředek",
        "definition" : "Zdravotnický prostředek...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani",
        "short" : "A.2.6.1.4 - Očkování",
        "definition" : "Historie očkování.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.puvodce",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.puvodce",
        "short" : "A.2.6.1.4.1 - Onemocnění či původce",
        "definition" : "Onemocnění či původce...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.typVakciny",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.typVakciny",
        "short" : "A.2.6.1.4.2 - Typ vakcíny",
        "definition" : "Typ vakcíny vyjádřený kódem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.ockovaciLatka",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.ockovaciLatka",
        "short" : "A.2.6.1.4.4 - Očkovací látka",
        "definition" : "Registrovaný název vakcíny...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.vyrobceVakciny",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.vyrobceVakciny",
        "short" : "A.2.6.1.4.5 - Držitel rozhodnutí",
        "definition" : "Výrobce vakcíny...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.poradoveCislo",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.poradoveCislo",
        "short" : "A.2.6.1.4.6 - Pořadové číslo dávky",
        "definition" : "Pořadové číslo dávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.datumPodani",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.datumPodani",
        "short" : "A.2.6.1.4.7 - Datum podání dávky",
        "definition" : "Přesné nebo přibližné datum podání.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.ockovani.pristiVakcinace",
        "path" : "logPatientHistoryCz.anamnezaOsobni.ockovani.pristiVakcinace",
        "short" : "A.2.6.1.4.8 - Datum příští vakcinace",
        "definition" : "Datum doporučeného přeočkování.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza",
        "short" : "A.2.6.1.5 - Epidemiologická anamnéza",
        "definition" : "Cestovatelská anamnéza a infekční kontakty.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt",
        "short" : "A.2.6.1.5.1 - Infekční kontakty",
        "definition" : "Infekční kontakty pacienta",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.period",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.period",
        "short" : "A.2.6.1.5.1.1 - Období",
        "definition" : "Období trvání infekčního kontaktu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.infectiousAgent",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.infectiousAgent",
        "short" : "A.2.6.1.5.1.2 - Infekční onemocnění či agens",
        "definition" : "In infekce...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.proximity",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.proximity",
        "short" : "A.2.6.1.5.1.3 - Vzdálenost",
        "definition" : "Typ expozice či vzdálenost...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.zeme",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.zeme",
        "short" : "A.2.6.1.5.1.4 - Země",
        "definition" : "Země, kde došlo ke kontaktu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.komentar",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.komentar",
        "short" : "A.2.6.1.5.1.5 - Komentář",
        "definition" : "Poznámky...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza",
        "short" : "A.2.6.1.5.2 - Cestovatelská anamnéza",
        "definition" : "Cestovatelská anamnéza.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.obdobi",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.obdobi",
        "short" : "A.2.6.1.5.2.1 - Období",
        "definition" : "Přesné či přibližné období pobytu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.zeme",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.zeme",
        "short" : "A.2.6.1.5.2.2 - Země",
        "definition" : "Navštívená země.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.komentar",
        "path" : "logPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.komentar",
        "short" : "A.2.6.1.5.2.3 - Komentář",
        "definition" : "Poznámky k pobytu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.rodinnaAnamneza",
        "path" : "logPatientHistoryCz.rodinnaAnamneza",
        "short" : "A.2.6.2 - Rodinná anamnéza",
        "definition" : "Informace o závažných onemocněních u blízkých pokrevně příbuzných...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.rodinnaAnamneza.vztahKPacientovi",
        "path" : "logPatientHistoryCz.rodinnaAnamneza.vztahKPacientovi",
        "short" : "A.2.6.2.1 - Vztah k pacientovi",
        "definition" : "Vztah osoby k pacientovi.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.rodinnaAnamneza.datumNarozeni",
        "path" : "logPatientHistoryCz.rodinnaAnamneza.datumNarozeni",
        "short" : "A.2.6.2.2 - Datum narození",
        "definition" : "Přesné či přibližné datum narození.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.rodinnaAnamneza.vekUmrti",
        "path" : "logPatientHistoryCz.rodinnaAnamneza.vekUmrti",
        "short" : "A.2.6.2.3 - Věk úmrtí",
        "definition" : "Věk nebo datum úmrtí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.rodinnaAnamneza.zdravotniProblemy",
        "path" : "logPatientHistoryCz.rodinnaAnamneza.zdravotniProblemy",
        "short" : "A.2.6.2.5 - Zdravotní problémy",
        "definition" : "Zdravotní problémy, jimiž osoba trpí či trpěla.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.rodinnaAnamneza.duvodUmrti",
        "path" : "logPatientHistoryCz.rodinnaAnamneza.duvodUmrti",
        "short" : "A.2.6.2.6 - Důvod úmrtí",
        "definition" : "Příčina úmrtí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza",
        "path" : "logPatientHistoryCz.socialniAnamneza",
        "short" : "A.2.6.3 - Sociální anamnéza",
        "definition" : "Sociální anamnéza",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni",
        "path" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni",
        "short" : "A.2.6.3.1 - Společenské uplatnění",
        "definition" : "Společenské zapojení...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.pracovniZapojeni",
        "path" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.pracovniZapojeni",
        "short" : "A.2.6.3.1.1 - Pracovní zapojení",
        "definition" : "Pracovním zapojením je...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.konicky",
        "path" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.konicky",
        "short" : "A.2.6.3.1.2 - Koníčky",
        "definition" : "Záliby...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.socialniSit",
        "path" : "logPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.socialniSit",
        "short" : "A.2.6.3.1.3 - Sociální síť",
        "definition" : "Popis sociální sítě...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.vzdelani",
        "path" : "logPatientHistoryCz.socialniAnamneza.vzdelani",
        "short" : "A.2.6.3.2 - Vzdělání",
        "definition" : "Vzdělání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.vzdelani.uroven",
        "path" : "logPatientHistoryCz.socialniAnamneza.vzdelani.uroven",
        "short" : "A.2.6.3.2.1 - Dosažený stupeň vzdělání",
        "definition" : "Stupeň dosaženého vzdělání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.vzdelani.komentar",
        "path" : "logPatientHistoryCz.socialniAnamneza.vzdelani.komentar",
        "short" : "A.2.6.3.2.2 - Komentář",
        "definition" : "Upřesnění...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.bydleni",
        "path" : "logPatientHistoryCz.socialniAnamneza.bydleni",
        "short" : "A.2.6.3.3 - Bydlení",
        "definition" : "Způsob bydlení...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.bydleni.zpusobBydleni",
        "path" : "logPatientHistoryCz.socialniAnamneza.bydleni.zpusobBydleni",
        "short" : "A.2.6.3.3.1 - Způsob bydlení",
        "definition" : "Druh bydlení...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.bydleni.prizpusobeni",
        "path" : "logPatientHistoryCz.socialniAnamneza.bydleni.prizpusobeni",
        "short" : "A.2.6.3.3.2 - Přizpůsobení",
        "definition" : "Úpravy domácnosti...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.bydleni.bariery",
        "path" : "logPatientHistoryCz.socialniAnamneza.bydleni.bariery",
        "short" : "A.2.6.3.3.3 - Bariéry",
        "definition" : "Podmínky bezbariérovosti.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace",
        "short" : "A.2.6.3.4 - Rodinná situace",
        "definition" : "Podrobnosti rodinné situace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.komentar",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.komentar",
        "short" : "A.2.6.3.4.1 - Komentář",
        "definition" : "Komentář k rodinné situaci.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.slozeniRodiny",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.slozeniRodiny",
        "short" : "A.2.6.3.4.2 - Složení rodiny",
        "definition" : "Složení rodiny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.rodinnyStav",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.rodinnyStav",
        "short" : "A.2.6.3.4.3 - Rodinný stav",
        "definition" : "Rodinný stav.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDeti",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDeti",
        "short" : "A.2.6.3.4.4 - Počet dětí",
        "definition" : "Celkový počet dětí...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDetiDoma",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDetiDoma",
        "short" : "A.2.6.3.4.5 - Počet dětí ve společné domácnosti",
        "definition" : "Počet dětí žijících doma.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.podrobnostiODiteti",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.podrobnostiODiteti",
        "short" : "A.2.6.3.4.6 - Podrobnosti o dítěti",
        "definition" : "Pro každé dítě: datum narození...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.pecujeO",
        "path" : "logPatientHistoryCz.socialniAnamneza.rodinnaSituace.pecujeO",
        "short" : "A.2.6.3.4.7 - Pečuje o",
        "definition" : "Činnosti, které pacient vykonává při péči o závislého člena rodiny.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus",
        "path" : "logPatientHistoryCz.abusus",
        "short" : "A.2.6.4 - Abusus",
        "definition" : "Informace o pravidelném kouření...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.alkohol",
        "path" : "logPatientHistoryCz.abusus.alkohol",
        "short" : "A.2.6.4.1 - Alkohol",
        "definition" : "Konzumace alkoholu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.alkohol.stav",
        "path" : "logPatientHistoryCz.abusus.alkohol.stav",
        "short" : "A.2.6.4.1.1 - Stav",
        "definition" : "Aktuální stav.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.alkohol.mnozstvi",
        "path" : "logPatientHistoryCz.abusus.alkohol.mnozstvi",
        "short" : "A.2.6.4.1.2 - Období a množství",
        "definition" : "Období a množství.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.alkohol.komentar",
        "path" : "logPatientHistoryCz.abusus.alkohol.komentar",
        "short" : "A.2.6.4.1.3 - Komentář",
        "definition" : "Komentář volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.koureni",
        "path" : "logPatientHistoryCz.abusus.koureni",
        "short" : "A.2.6.4.2 - Kouření",
        "definition" : "Kouření.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.koureni.stav",
        "path" : "logPatientHistoryCz.abusus.koureni.stav",
        "short" : "A.2.6.4.2.1 - Stav",
        "definition" : "Stav kouření kódem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.koureni.mnozstvi",
        "path" : "logPatientHistoryCz.abusus.koureni.mnozstvi",
        "short" : "A.2.6.4.2.2 - Období a průměrné množství.",
        "definition" : "Období a množství.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.koureni.komentar",
        "path" : "logPatientHistoryCz.abusus.koureni.komentar",
        "short" : "A.2.6.4.2.3 - Komentář",
        "definition" : "Komentář volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.drogy",
        "path" : "logPatientHistoryCz.abusus.drogy",
        "short" : "A.2.6.4.3 - Drogy",
        "definition" : "Drogová závislost.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.drogy.stav",
        "path" : "logPatientHistoryCz.abusus.drogy.stav",
        "short" : "A.2.6.4.3.1 - Stav",
        "definition" : "Aktuální stav drogové závislosti.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.drogy.mnozstvi",
        "path" : "logPatientHistoryCz.abusus.drogy.mnozstvi",
        "short" : "A.2.6.4.3.2 - Období a množství",
        "definition" : "Období a množství/kvantifikace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.drogy.typLatky",
        "path" : "logPatientHistoryCz.abusus.drogy.typLatky",
        "short" : "A.2.6.4.3.3 - Typ látky",
        "definition" : "Typ užívané látky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.drogy.zpusobPodani",
        "path" : "logPatientHistoryCz.abusus.drogy.zpusobPodani",
        "short" : "A.2.6.4.3.4 - Způsob podávání",
        "definition" : "Způsob administrace látky.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.abusus.drogy.komentar",
        "path" : "logPatientHistoryCz.abusus.drogy.komentar",
        "short" : "A.2.6.4.3.5 - Komentář",
        "definition" : "Komentář volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPatientHistoryCz.zavislosti",
        "path" : "logPatientHistoryCz.zavislosti",
        "short" : "A.2.6.4.4 - Závislosti",
        "definition" : "Závislosti volným textem nebo kódem onemocnění.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
