# A.2.7 - Průběh ambulantního kontaktu - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.7 - Průběh ambulantního kontaktu**

## Logical Model: A.2.7 - Průběh ambulantního kontaktu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logOutpatientStayCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzOutpatientStayCz |

 
Popis průběhu ambulantního kontaktu zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí. 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logOutpatientStayCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logOutpatientStayCz.csv), [Excel](StructureDefinition-logOutpatientStayCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logOutpatientStayCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logOutpatientStayCz",
  "version" : "0.1.0",
  "name" : "LogCzOutpatientStayCz",
  "title" : "A.2.7 - Průběh ambulantního kontaktu",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Popis průběhu ambulantního kontaktu zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logOutpatientStayCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logOutpatientStayCz",
        "path" : "logOutpatientStayCz",
        "short" : "A.2.7 - Průběh ambulantního kontaktu",
        "definition" : "Popis průběhu ambulantního kontaktu zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí."
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn",
        "path" : "logOutpatientStayCz.diagnostickySouhrn",
        "short" : "A.2.7.1 - Diagnostický souhrn",
        "definition" : "Seznam diagnóz, příznaků a problémů relevantních pro daný ambulantní kontakt. Popisuje problémy aktivní v průběhu kontaktu nebo významné pro další péči; může být kódován i textově.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.popisProblemu",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.popisProblemu",
        "short" : "A.2.7.1.1 - Popis problému",
        "definition" : "Popis problému textem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.kod",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.kod",
        "short" : "A.2.7.1.2 - Kód",
        "definition" : "Formalizované vyjádření zdravotního problému kódem (např. MKN-10, MKN-O).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.datumVzniku",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.datumVzniku",
        "short" : "A.2.7.1.3 - Datum vzniku",
        "definition" : "Datum vzniku onemocnění nebo příznaku, pokud je známo.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.datumVyreseniRemise",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.datumVyreseniRemise",
        "short" : "A.2.7.1.4 - Datum vyřešení či remise",
        "definition" : "Datum remise nebo zlepšení, pokud je relevantní.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.okolnostiVyreseni",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.okolnostiVyreseni",
        "short" : "A.2.7.1.5 - Okolnosti vyřešení",
        "definition" : "Důvod změny stavu problému na neaktivní (např. provedený výkon).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.zavaznost",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.zavaznost",
        "short" : "A.2.7.1.6 - Závažnost",
        "definition" : "Subjektivní hodnocení závažnosti stavu klinikem (např. h7:condition-severity).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.diagnostickySouhrn.stadiumOnemocneni",
        "path" : "logOutpatientStayCz.diagnostickySouhrn.stadiumOnemocneni",
        "short" : "A.2.7.1.7 - Stadium onemocnění",
        "definition" : "Stadium nebo grading problému podle zvolené klasifikace (např. TNM).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony",
        "path" : "logOutpatientStayCz.vykony",
        "short" : "A.2.7.2 - Výkony",
        "definition" : "Diagnostické a terapeutické výkony provedené v průběhu ambulantního kontaktu.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.kodVykonu",
        "path" : "logOutpatientStayCz.vykony.kodVykonu",
        "short" : "A.2.7.2.1 - Kód výkonu",
        "definition" : "Kód výkonu ve vybraném kódovém systému (SNOMED CT, ICHI apod.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.popisProcedury",
        "path" : "logOutpatientStayCz.vykony.popisProcedury",
        "short" : "A.2.7.2.2 - Popis procedury",
        "definition" : "Popis výkonu volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.lokalizace",
        "path" : "logOutpatientStayCz.vykony.lokalizace",
        "short" : "A.2.7.2.3 - Lokalizace",
        "definition" : "Anatomická lokalizace výkonu pomocí řízené terminologie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.datumProvedeni",
        "path" : "logOutpatientStayCz.vykony.datumProvedeni",
        "short" : "A.2.7.2.4 - Datum provedení",
        "definition" : "Datum provedení výkonu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.duvodProvedeni",
        "path" : "logOutpatientStayCz.vykony.duvodProvedeni",
        "short" : "A.2.7.2.5 - Důvod provedení",
        "definition" : "Důvod provedení výkonu textem nebo kódem (např. MKN-10).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.vysledek",
        "path" : "logOutpatientStayCz.vykony.vysledek",
        "short" : "A.2.7.2.6 - Výsledek",
        "definition" : "Formalizované vyjádření výsledku výkonu (procedure-outcome).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.komplikace",
        "path" : "logOutpatientStayCz.vykony.komplikace",
        "short" : "A.2.7.2.7 - Komplikace",
        "definition" : "Komplikace spojené s výkonem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vykony.cilovyZdravProstredek",
        "path" : "logOutpatientStayCz.vykony.cilovyZdravProstredek",
        "short" : "A.2.7.2.8 - Cílový zdravotnický prostředek",
        "definition" : "Odkaz na zdravotnický prostředek implantovaný nebo jinak využitý během výkonu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.zdravotniPomucky",
        "path" : "logOutpatientStayCz.zdravotniPomucky",
        "short" : "A.2.7.3 - Zdravotní pomůcky a implantáty",
        "definition" : "Zavedené nebo použité zdravotní pomůcky relevantní pro ambulantní kontakt.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.zdravotniPomucky.popisProstredku",
        "path" : "logOutpatientStayCz.zdravotniPomucky.popisProstredku",
        "short" : "A.2.7.3.1 - Popis zdravotnického prostředku",
        "definition" : "Popis zdravotnického prostředku (implantovaného či externího) textem a/nebo kódem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.zdravotniPomucky.identifikatorProstredku",
        "path" : "logOutpatientStayCz.zdravotniPomucky.identifikatorProstredku",
        "short" : "A.2.7.3.2 - Identifikátor prostředku",
        "definition" : "Normalizovaný identifikátor, např. UDI.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.zdravotniPomucky.datumZavedeni",
        "path" : "logOutpatientStayCz.zdravotniPomucky.datumZavedeni",
        "short" : "A.2.7.3.3 - Datum zavedení",
        "definition" : "Datum zavedení nebo první evidence prostředku relevantní pro kontakt.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.zdravotniPomucky.datumOdstraneni",
        "path" : "logOutpatientStayCz.zdravotniPomucky.datumOdstraneni",
        "short" : "A.2.7.3.4 - Datum odstranění",
        "definition" : "Datum odstranění nebo ukončení užívání prostředku, pokud se vztahuje.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.zdravotniPomucky.duvodPouziti",
        "path" : "logOutpatientStayCz.zdravotniPomucky.duvodPouziti",
        "short" : "A.2.7.3.5 - Důvod použití",
        "definition" : "Klinický důvod zavedení či použití zdravotnického prostředku.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.dalsiVyznamnaLecba",
        "path" : "logOutpatientStayCz.dalsiVyznamnaLecba",
        "short" : "A.2.7.4 - Další významná léčba",
        "definition" : "Významné léčebné postupy, které nejsou klasifikovány jako standardní ambulantní výkony (např. chemoterapie, infuzní terapie apod.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.dalsiVyznamnaLecba.popisProcedury",
        "path" : "logOutpatientStayCz.dalsiVyznamnaLecba.popisProcedury",
        "short" : "A.2.7.4.1 - Popis procedury",
        "definition" : "Popis léčebné procedury volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.dalsiVyznamnaLecba.lokalizace",
        "path" : "logOutpatientStayCz.dalsiVyznamnaLecba.lokalizace",
        "short" : "A.2.7.4.2 - Lokalizace",
        "definition" : "Anatomická lokalizace, je-li relevantní.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.dalsiVyznamnaLecba.datumProvedeni",
        "path" : "logOutpatientStayCz.dalsiVyznamnaLecba.datumProvedeni",
        "short" : "A.2.7.4.3 - Datum provedení",
        "definition" : "Datum provedení léčebné procedury",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.dalsiVyznamnaLecba.duvodProvedeni",
        "path" : "logOutpatientStayCz.dalsiVyznamnaLecba.duvodProvedeni",
        "short" : "A.2.7.4.4 - Důvod provedení",
        "definition" : "Důvod provedení léčebné procedury textem nebo kódem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace",
        "path" : "logOutpatientStayCz.medikace",
        "short" : "A.2.7.5 - Medikace",
        "definition" : "Vybraná medikamentózní léčba v průběhu ambulantního kontaktu nebo předepsaná při jeho ukončení.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.indikace",
        "path" : "logOutpatientStayCz.medikace.indikace",
        "short" : "A.2.7.5.1 - Indikace",
        "definition" : "Důvod podání/indikační důvod medikace (text nebo odkaz na problém).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.kodSUKL",
        "path" : "logOutpatientStayCz.medikace.kodSUKL",
        "short" : "A.2.7.5.2 - Kód SUKL",
        "definition" : "Kód léčiva dle databáze SÚKL, pokud je k dispozici.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.nazevLecivehoPripravku",
        "path" : "logOutpatientStayCz.medikace.nazevLecivehoPripravku",
        "short" : "A.2.7.5.3 - Název léčivého přípravku",
        "definition" : "Registrovaný název léčiva.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.aktivniLatky",
        "path" : "logOutpatientStayCz.medikace.aktivniLatky",
        "short" : "A.2.7.5.4 - Aktivní látky",
        "definition" : "Seznam aktivních látek (název a/nebo kód ATC/IDMP).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.sila",
        "path" : "logOutpatientStayCz.medikace.sila",
        "short" : "A.2.7.5.5 - Síla",
        "definition" : "Síla aktivní látky v přípravku (vyjádřeno v jednotkách).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.formaLeciva",
        "path" : "logOutpatientStayCz.medikace.formaLeciva",
        "short" : "A.2.7.5.6 - Forma léčiva",
        "definition" : "Léková forma (např. tableta, sirup).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.davkovani",
        "path" : "logOutpatientStayCz.medikace.davkovani",
        "short" : "A.2.7.5.7 - Dávkování",
        "definition" : "Frekvence a počet jednotek podání volným textem nebo formalizovaně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.cestaPodani",
        "path" : "logOutpatientStayCz.medikace.cestaPodani",
        "short" : "A.2.7.5.8 - Cesta podání",
        "definition" : "Cesta podání (např. per os, i.v.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.medikace.obdobiPodavani",
        "path" : "logOutpatientStayCz.medikace.obdobiPodavani",
        "short" : "A.2.7.5.9 - Období podávání",
        "definition" : "Časový interval, kdy byla medikace podávána nebo je indikována.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni",
        "path" : "logOutpatientStayCz.vysledkyVysetreni",
        "short" : "A.2.7.6 Výsledky vyšetření",
        "definition" : "Významné výsledky funkčních, diagnostických a zobrazovacích vyšetření, provedených během hospitalizace. Výsledky s nezpracovaným stavem („registered“) mají být uvedeny odděleně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni.datum",
        "path" : "logOutpatientStayCz.vysledkyVysetreni.datum",
        "short" : "A.2.7.6.1 - Date",
        "definition" : "Date and time of the observation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni.stav",
        "path" : "logOutpatientStayCz.vysledkyVysetreni.stav",
        "short" : "A.2.7.6.2 - Observation status",
        "definition" : "Status of the observation (e.g. registered, preliminary, final)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni.vysledek",
        "path" : "logOutpatientStayCz.vysledkyVysetreni.vysledek",
        "short" : "A.2.7.6.3 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni.popis",
        "path" : "logOutpatientStayCz.vysledkyVysetreni.popis",
        "short" : "A.2.7.6.4 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni.vysledekFormalizovany",
        "path" : "logOutpatientStayCz.vysledkyVysetreni.vysledekFormalizovany",
        "short" : "A.2.7.6.5 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.vysledkyVysetreni.provedl",
        "path" : "logOutpatientStayCz.vysledkyVysetreni.provedl",
        "short" : "A.2.7.6.7 - Reporter",
        "definition" : "With certain observation results, e.g. there may also be an interpreter or a person responsible for validation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.klinickeShrnuti",
        "path" : "logOutpatientStayCz.klinickeShrnuti",
        "short" : "A.2.7.7 Klinické shrnutí",
        "definition" : "Podrobný popis důvodu a průběhu hospitalizace jako celku. Může být zakončeno klinickou úvahou (dif. dg., vysvětlení souvislostí) v klinicky složitých případech.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.klinickeShrnuti.souhrnProblemu",
        "path" : "logOutpatientStayCz.klinickeShrnuti.souhrnProblemu",
        "short" : "A.2.7.7.1 Klinický souhrn problému",
        "definition" : "Souhrnný popis důvodu a průběhu ambulantního kontaktu za konkrétní problém.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.klinickeShrnuti.souhrnProblemu.popisProblemu",
        "path" : "logOutpatientStayCz.klinickeShrnuti.souhrnProblemu.popisProblemu",
        "short" : "A.2.7.7.1.1 Popis problému",
        "definition" : "Popis problému textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.klinickeShrnuti.souhrnProblemu.duvod",
        "path" : "logOutpatientStayCz.klinickeShrnuti.souhrnProblemu.duvod",
        "short" : "A.2.7.7.1.2 Důvod a průběh ambulantního kontaktu",
        "definition" : "Podrobný popis důvodu a průběhu ambulantního kontaktu za celý pobyt.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logOutpatientStayCz.klinickeShrnuti.klinickaUvaha",
        "path" : "logOutpatientStayCz.klinickeShrnuti.klinickaUvaha",
        "short" : "A.2.7.7.2 Klinická úvaha",
        "definition" : "Zakončení klinického shrnutí klinickou úvahou (diferenciální diagnostika, vysvětlení složitých stavů apod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
