# A.2.3 - Údaje o ambulantním kontaktu - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.3 - Údaje o ambulantním kontaktu**

## Logical Model: A.2.3 - Údaje o ambulantním kontaktu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logEncounterCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzEncounterCz |

 
Záznam o ambulantním kontaktu v rámci ambulantní zprávy. 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logEncounterCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logEncounterCz.csv), [Excel](StructureDefinition-logEncounterCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logEncounterCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logEncounterCz",
  "version" : "0.1.0",
  "name" : "LogCzEncounterCz",
  "title" : "A.2.3 - Údaje o ambulantním kontaktu",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Záznam o ambulantním kontaktu v rámci ambulantní zprávy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logEncounterCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logEncounterCz",
        "path" : "logEncounterCz",
        "short" : "A.2.3 - Údaje o ambulantním kontaktu",
        "definition" : "Záznam o ambulantním kontaktu v rámci ambulantní zprávy."
      },
      {
        "id" : "logEncounterCz.typ",
        "path" : "logEncounterCz.typ",
        "short" : "A.2.3.1 - Typ ambulantního kontaktu",
        "definition" : "Typ ambulantního kontaktu IMP, ACUTE, NONAC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logEncounterCz.poznamka",
        "path" : "logEncounterCz.poznamka",
        "short" : "A.2.3.2 - Poznámka",
        "definition" : "Poznámka k ambulantnímu kontaktu volným textem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logEncounterCz.datum",
        "path" : "logEncounterCz.datum",
        "short" : "A.2.3.3 - Datum a čas vyšetření",
        "definition" : "Datum a čas vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logEncounterCz.prijem",
        "path" : "logEncounterCz.prijem",
        "short" : "A.2.3.4 - Příjem",
        "definition" : "Informace o příjmu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logEncounterCz.prijem.urgentni",
        "path" : "logEncounterCz.prijem.urgentni",
        "short" : "A.2.3.4.1 - Urgentnost ambulantního kontaktu",
        "definition" : "Akutní nebo plánovaný",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logEncounterCz.prijem.lekarId",
        "path" : "logEncounterCz.prijem.lekarId",
        "short" : "A.2.3.4.2 - Doporučující lékař - Id",
        "definition" : "Identifikátor odesílajícího lékaře dle NRZP",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logEncounterCz.prijem.lekarJmeno",
        "path" : "logEncounterCz.prijem.lekarJmeno",
        "short" : "A.2.3.4.3 - Doporučující lékař - jméno",
        "definition" : "Jméno a příjmení odesílajícího lékaře",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logEncounterCz.prijem.doporucilOrganizaceId",
        "path" : "logEncounterCz.prijem.doporucilOrganizaceId",
        "short" : "A.2.3.4.4 - Doporučující zařízení",
        "definition" : "Id, název poskytovatele a kontaktní informace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logEncounterCz.duvodPrijeti",
        "path" : "logEncounterCz.duvodPrijeti",
        "short" : "A.2.3.5 - Důvod ambulantního kontaktu",
        "definition" : "Důvod ambulantního kontaktu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logEncounterCz.duvodPrijeti.kod",
        "path" : "logEncounterCz.duvodPrijeti.kod",
        "short" : "A.2.3.5.1 - Důvod ambulantního kontaktu - kód",
        "definition" : "Důvod ambulantního kontaktu textem a/nebo kódem problému, nálezu či procedury",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logEncounterCz.duvodPrijeti.komentar",
        "path" : "logEncounterCz.duvodPrijeti.komentar",
        "short" : "A.2.3.5.2 - Důvod ambulantního kontaktu - komentář",
        "definition" : "Komentář k důvodu ambulantního kontaktu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logEncounterCz.poskytovatel",
        "path" : "logEncounterCz.poskytovatel",
        "short" : "A.2.3.6 - Poskytovatel ambulantní služby",
        "definition" : "Identifikaci zdravotnického pracoviště, na kterém byla ambulantní služba poskytnuta",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logEncounterCz.poskytovatel.od",
        "path" : "logEncounterCz.poskytovatel.od",
        "short" : "A.2.3.6.1 - od do",
        "definition" : "Období pobytu na oddělení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logEncounterCz.poskytovatel.id",
        "path" : "logEncounterCz.poskytovatel.id",
        "short" : "A.2.3.6.2 - Identifikátor",
        "definition" : "Úplný kód pracoviště/oddělení dle NRPZS",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logEncounterCz.poskytovatel.nazev",
        "path" : "logEncounterCz.poskytovatel.nazev",
        "short" : "A.2.3.6.3 - Název",
        "definition" : "Název oddělení",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logEncounterCz.poskytovatel.kontakt",
        "path" : "logEncounterCz.poskytovatel.kontakt",
        "short" : "A.2.3.6.4 - Kontakty",
        "definition" : "Adresa a telekomunikační kontakty",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
