# A.2.1 - Dříve vyslovená přání - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.1 - Dříve vyslovená přání**

## Logical Model: A.2.1 - Dříve vyslovená přání 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logAdvanceDirectivesCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzAdvanceDirectivesCz |

 
Ambulantní zpráva - Dříve vyslovená přání 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logAdvanceDirectivesCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAdvanceDirectivesCz.csv), [Excel](StructureDefinition-logAdvanceDirectivesCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAdvanceDirectivesCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logAdvanceDirectivesCz",
  "version" : "0.1.0",
  "name" : "LogCzAdvanceDirectivesCz",
  "title" : "A.2.1 - Dříve vyslovená přání",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Ambulantní zpráva - Dříve vyslovená přání ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logAdvanceDirectivesCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAdvanceDirectivesCz",
        "path" : "logAdvanceDirectivesCz",
        "short" : "A.2.1 - Dříve vyslovená přání",
        "definition" : "Ambulantní zpráva - Dříve vyslovená přání "
      },
      {
        "id" : "logAdvanceDirectivesCz.driveVyslovenaPrani",
        "path" : "logAdvanceDirectivesCz.driveVyslovenaPrani",
        "short" : "A.2.1.1 - Dříve vyslovená přání",
        "definition" : "Záznam dříve vysloveného přání. Pouze záznamy, které jsou vyjádřeny během aktuálního hospitalizačního pobytu. Může být uvedeno více záznamů dříve vyslovených přání.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdvanceDirectivesCz.driveVyslovenaPrani.datum",
        "path" : "logAdvanceDirectivesCz.driveVyslovenaPrani.datum",
        "short" : "A.2.1.1.1 - Datum a čas",
        "definition" : "Datum a čas vyjádřeného přání pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAdvanceDirectivesCz.driveVyslovenaPrani.typ",
        "path" : "logAdvanceDirectivesCz.driveVyslovenaPrani.typ",
        "short" : "A.2.1.1.2 - Typ přání",
        "definition" : "Typ přání kódem nebo textem. Např. Příkaz k resuscitaci, prohlášení o darování orgánů, plná moc apod.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAdvanceDirectivesCz.driveVyslovenaPrani.komentar",
        "path" : "logAdvanceDirectivesCz.driveVyslovenaPrani.komentar",
        "short" : "A.2.1.1.3 - Komentář",
        "definition" : "Komentář k projevenému přání pacienta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAdvanceDirectivesCz.driveVyslovenaPrani.stav",
        "path" : "logAdvanceDirectivesCz.driveVyslovenaPrani.stav",
        "short" : "A.2.1.1.4 - Dotčený stav",
        "definition" : "Stav na který se přání vztahuje. Přání může být vztaženo pouze k určitému zdravotnímu problému či množině problémů.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdvanceDirectivesCz.driveVyslovenaPrani.dokument",
        "path" : "logAdvanceDirectivesCz.driveVyslovenaPrani.dokument",
        "short" : "A.2.1.1.5 - Dokument",
        "definition" : "Fotokopie dokumentu či elektronický dokument s projeveným přáním pacienta mající náležitosti požadované zákonem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
