# A.2.4 - Stav při přijetí - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.4 - Stav při přijetí**

## Logical Model: A.2.4 - Stav při přijetí 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logAdmissionEvaluationCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzAdmissionEvaluationCz |

 
Stav při přijetí (Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče.) 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logAdmissionEvaluationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAdmissionEvaluationCz.csv), [Excel](StructureDefinition-logAdmissionEvaluationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAdmissionEvaluationCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logAdmissionEvaluationCz",
  "version" : "0.1.0",
  "name" : "LogCzAdmissionEvaluationCz",
  "title" : "A.2.4 - Stav při přijetí",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Stav při přijetí (Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče.)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logAdmissionEvaluationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAdmissionEvaluationCz",
        "path" : "logAdmissionEvaluationCz",
        "short" : "A.2.4 - Stav při přijetí",
        "definition" : "Stav při přijetí (Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče.)"
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez",
        "path" : "logAdmissionEvaluationCz.objektivniNalez",
        "short" : "A.2.4.1 - Objektivní nález",
        "definition" : "Objektivní nález",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.datum",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.datum",
        "short" : "A.2.4.1.1 - Datum a čas",
        "definition" : "Datum a čas vyšetření pacienta lékařem v průběhu jeho přijímání k hospitalizaci",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.provedl",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.provedl",
        "short" : "A.2.4.1.2 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje",
        "short" : "A.2.4.1.3 - Anthropometrické údaje",
        "definition" : "Výsledky antropometrických měření pacienta: Požadované: výška, hmotnost, BMI (automatický výpočet z uvedených hodnot) Volitelné: obvod hlavy, hrudníku, břicha…",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.text",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.text",
        "short" : "A.2.4.1.3.1 - Výsledky měření textem",
        "definition" : "Textový popis výsledku vyšetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek",
        "short" : "A.2.4.1.3.2 - Parametrický záznam vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.popisVysetreni",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.popisVysetreni",
        "short" : "A.2.4.1.3.2.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.formalizovany",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.formalizovany",
        "short" : "A.2.4.1.3.2.2 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Obsah výsledku vyšetření se bude lišit podle typu vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.provedl",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.provedl",
        "short" : "A.2.4.1.3.2.3 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce",
        "short" : "A.2.4.1.4 - Základní životní funkce",
        "definition" : "Výsledky měření základních životních funkcí pacienta: Požadované: Tepová frekvence, dechová frekvence, TK s uvedením strany měření, Volitelné: Saturace 02",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.typVysetreni",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.typVysetreni",
        "short" : "A.2.4.1.4.1 - Typ Vyšetření",
        "definition" : "Klasifikace typu vyšetření. Zde fixní hodnota: vital-signs",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.text",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.text",
        "short" : "A.2.4.1.4.2 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek",
        "short" : "A.2.4.1.4.3 - Parametrický záznam vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.popisVysetreni",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.popisVysetreni",
        "short" : "A.2.4.1.4.3.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.formalizovany",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.formalizovany",
        "short" : "A.2.4.1.4.3.2 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Obsah výsledku vyšetření se bude lišit podle typu vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.provedl",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.provedl",
        "short" : "A.2.4.1.4.3.3 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni",
        "short" : "A.2.4.1.5 - Somatické vyšetření",
        "definition" : "Vyšetření pomocí smyslů vyšetřujícího (pohledem, poslechem, pohmatem a poklepem) a posuzování, zda se takto zjištěné nálezy odchylují od normy. Pokud ano, označujeme tyto odchylky jako objektivní příznaky (angl. signs). ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.text",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.text",
        "short" : "A.2.4.1.5.1 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku vyšetření. Mělo by být strukturováno podle časti těla (e.g. Hlava, krk, ramena, ruce, ...)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.provedl",
        "path" : "logAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.provedl",
        "short" : "A.2.4.1.5.2 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav",
        "path" : "logAdmissionEvaluationCz.funkcniStav",
        "short" : "A.2.4.2 - Funkční stav",
        "definition" : "Funkční stav lze hodnotit několika různými způsoby, obvykle se zaměřením na schopnosti osoby vykonávat základní aktivity každodenního života (ADL), které zahrnují základní sebeobsluhu, jako je koupání, krmení a toaleta a instrumentální aktivity každodenního života (IADL), které zahrnují činnosti jako vaření, nakupování a řízení vlastních záležitostí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.datum",
        "path" : "logAdmissionEvaluationCz.funkcniStav.datum",
        "short" : "A.2.4.2.1 - Datum a čas",
        "definition" : "Datum a čas hodnocení funkčního stavu pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.provedl",
        "path" : "logAdmissionEvaluationCz.funkcniStav.provedl",
        "short" : "A.2.4.2.2 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.popis",
        "path" : "logAdmissionEvaluationCz.funkcniStav.popis",
        "short" : "A.2.4.2.3 - Popis",
        "definition" : "Textový popis funkčního stavu pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane",
        "path" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane",
        "short" : "A.2.4.2.4 - Hodnocení formalizované",
        "definition" : "Formalizované hodnocení funkčního stavu pacienta dle jednotlivých hodnotících kategorií zvoleného systému hodnocení (např. MKF)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.datumVzniku",
        "path" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.datumVzniku",
        "short" : "A.2.4.2.4.1 - Datum vzniku",
        "definition" : "Datum vzniku funkčního omezení",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.text",
        "path" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.text",
        "short" : "A.2.4.2.4.2 - Výsledek vyšetření textem",
        "definition" : "Výsledek vyšetření volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.popis",
        "path" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.popis",
        "short" : "A.2.4.2.4.3 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu. Jako výchozí systém pro hodnocení funkčního stavu byl zvolen mezinárodní klasifikační systém MKF. Další typy hodnotících škál mohou být doplněny v budoucích verzích standardu na základě potřeby a konsenzu odborné veřejnosti. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.formalizovany",
        "path" : "logAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.formalizovany",
        "short" : "A.2.4.2.4.4 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek hodnocení funkčního stavu v dané kategorii hodnocení.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
