# Flag: Outpatient Encounter Report (CZ) - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Flag: Outpatient Encounter Report (CZ)**

## Resource Profile: Flag: Outpatient Encounter Report (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/cz-flag-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:CZ_FlagAmb |

 
Flag resource to represent important clinical or administrative information about the patient relevant to ambulatory care in the scope of this guide. 

**Usages:**

* Derived from this Profile: [Flag Obligations (AMB CZ)](StructureDefinition-cz-flag-obl-amb.md)
* Use this Profile: [Bundle Outpatient Encounter Report (CZ)](StructureDefinition-cz-bundle-amb.md)
* Refer to this Profile: [Composition: Outpatient Encounter Report (CZ)](StructureDefinition-cz-composition-amb.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/cz-flag-amb)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-flag-amb.csv), [Excel](StructureDefinition-cz-flag-amb.xlsx), [Schematron](StructureDefinition-cz-flag-amb.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-flag-amb",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-flag-amb",
  "version" : "0.1.0",
  "name" : "CZ_FlagAmb",
  "title" : "Flag: Outpatient Encounter Report (CZ)",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Flag resource to represent important clinical or administrative information about the patient relevant to ambulatory\ncare in the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Flag",
  "baseDefinition" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Flag",
        "path" : "Flag",
        "short" : "Flag for Ambulatory Care",
        "definition" : "Flag resource to represent important clinical or administrative information about the patient relevant to ambulatory care."
      }
    ]
  }
}

```
