# Composition: Outpatient Encounter Report (CZ) - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition: Outpatient Encounter Report (CZ)**

## Resource Profile: Composition: Outpatient Encounter Report (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/cz-composition-amb | *Version*:0.1.0 | |
| * Standards status: *[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_CompositionAmb |
| **Copyright/Legal**: HL7 CZ | | |

 
Clinical document used to represent an Outpatient Encounter Report for the scope of this guide. 

 
Outpatient Encounter Report composition is an electronic health record extract containing Outpatient Encounter Report. 

**Usages:**

* Use this Profile: [Bundle Outpatient Encounter Report (CZ)](StructureDefinition-cz-bundle-amb.md)
* Examples for this Profile: [Composition/698056a8-57a6-49ed-909e-ea4216b18a6d](Composition-698056a8-57a6-49ed-909e-ea4216b18a6d.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/cz-composition-amb)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-amb.csv), [Excel](StructureDefinition-cz-composition-amb.xlsx), [Schematron](StructureDefinition-cz-composition-amb.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-composition-amb",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-composition-amb",
  "version" : "0.1.0",
  "name" : "CZ_CompositionAmb",
  "title" : "Composition: Outpatient Encounter Report (CZ)",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent an Outpatient Encounter Report for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Outpatient Encounter Report composition is an electronic health record extract containing Outpatient Encounter Report.",
  "copyright" : "HL7 CZ",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Outpatient Encounter Report Composition",
        "definition" : "Outpatient Encounter Report Composition. \r\n\r\n A composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained."
      },
      {
        "id" : "Composition.meta.security",
        "path" : "Composition.meta.security",
        "mustSupport" : true
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.extension:basedOn",
        "path" : "Composition.extension",
        "sliceName" : "basedOn",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/event-basedOn"]
          }
        ]
      },
      {
        "id" : "Composition.extension:basedOn.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Resource",
              "http://hl7.org/fhir/StructureDefinition/ServiceRequest"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm",
        "path" : "Composition.extension",
        "sliceName" : "presentedForm",
        "short" : "Presented form",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/presentedForm"]
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].contentType",
        "path" : "Composition.extension.value[x].contentType",
        "example" : [
          {
            "label" : "pdf",
            "valueCode" : "application/pdf"
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].data",
        "path" : "Composition.extension.value[x].data",
        "short" : "B64 in-line data"
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].url",
        "path" : "Composition.extension.value[x].url",
        "short" : "URL of the document"
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Report identifier",
        "definition" : "Identifiers assigned to this report by the performer or other systems. It shall be common to several report versions",
        "comment" : "Composition.identifier SHALL be equal to one of the OrderInformation.identifier, if at least one exists"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "Status of the Order"
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Context that defines the Outpatient Encounter Report",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "Date the order was created."
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Outpatient Encounter Report",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "short" : "Organization that manages the Outpatient Encounter Report",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives",
        "path" : "Composition.section",
        "sliceName" : "sectionAdvanceDirectives",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "42348-3",
              "display" : "Advance directives"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr",
              "http://hl7.org/fhir/StructureDefinition/Consent",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies",
        "path" : "Composition.section",
        "sliceName" : "sectionAllergies",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAllergies.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48765-2",
              "display" : "Allergies and intolerances"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAllergies.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/amb/StructureDefinition/cz-allergyintolerance-amb",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance",
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlerts",
        "path" : "Composition.section",
        "sliceName" : "sectionAlerts",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAlerts.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAlerts.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "104605-1",
              "display" : "Alerts"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAlerts.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAlerts.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/amb/StructureDefinition/cz-flag-amb",
              "http://hl7.org/fhir/StructureDefinition/Flag",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionClinicalStatusAtPresentation",
        "path" : "Composition.section",
        "sliceName" : "sectionClinicalStatusAtPresentation",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionClinicalStatusAtPresentation.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionClinicalStatusAtPresentation.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51848-0",
              "display" : "Evaluation note"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionClinicalStatusAtPresentation.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionClinicalStatusAtPresentation.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory",
        "path" : "Composition.section",
        "sliceName" : "sectionPatientHistory",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "35090-0",
              "display" : "Patient history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:PastIllnessHx",
        "path" : "Composition.section.section",
        "sliceName" : "PastIllnessHx",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:PastIllnessHx.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Past illness history"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:PastIllnessHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11348-0",
              "display" : "Past illness history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:PastIllnessHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:PastIllnessHx.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:HistoryMedicalDevices",
        "path" : "Composition.section.section",
        "sliceName" : "HistoryMedicalDevices",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:HistoryMedicalDevices.title",
        "path" : "Composition.section.section.title",
        "patternString" : "History of medical devices"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:HistoryMedicalDevices.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "46264-8",
              "display" : "History of medical device use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:HistoryMedicalDevices.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:HistoryMedicalDevices.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:ProceduresHx",
        "path" : "Composition.section.section",
        "sliceName" : "ProceduresHx",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:ProceduresHx.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Procedures history"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:ProceduresHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11369-6",
              "display" : "Procedures history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:ProceduresHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:ProceduresHx.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:Immunizations",
        "path" : "Composition.section.section",
        "sliceName" : "Immunizations",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:Immunizations.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Immunizations"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:Immunizations.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11369-6",
              "display" : "Immunizations history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:Immunizations.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:Immunizations.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Immunization",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:InfectiousContacts",
        "path" : "Composition.section.section",
        "sliceName" : "InfectiousContacts",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:InfectiousContacts.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Infectious contacts"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:InfectiousContacts.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11348-0",
              "display" : "Infectious disease contact"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:InfectiousContacts.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:InfectiousContacts.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TravelHx",
        "path" : "Composition.section.section",
        "sliceName" : "TravelHx",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TravelHx.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Travel history"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TravelHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11347-2",
              "display" : "Travel history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TravelHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TravelHx.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:FamilyHistory",
        "path" : "Composition.section.section",
        "sliceName" : "FamilyHistory",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:FamilyHistory.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Family history"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:FamilyHistory.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10157-6",
              "display" : "Family history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:FamilyHistory.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:FamilyHistory.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:SocialHistory",
        "path" : "Composition.section.section",
        "sliceName" : "SocialHistory",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:SocialHistory.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Sociální anamnéza"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:SocialHistory.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29762-2",
              "display" : "Social history"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:SocialHistory.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:SocialHistory.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:AlcoholUse",
        "path" : "Composition.section.section",
        "sliceName" : "AlcoholUse",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:AlcoholUse.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Alcohol use"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:AlcoholUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72163-9",
              "display" : "Alcohol use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:AlcoholUse.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:AlcoholUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TobaccoUse",
        "path" : "Composition.section.section",
        "sliceName" : "TobaccoUse",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TobaccoUse.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Tobacco use"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TobaccoUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72164-7",
              "display" : "Tobacco use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TobaccoUse.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:TobaccoUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:DrugUse",
        "path" : "Composition.section.section",
        "sliceName" : "DrugUse",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:DrugUse.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Drug use"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:DrugUse.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72165-4",
              "display" : "Drug use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:DrugUse.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:DrugUse.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:OtherAddictions",
        "path" : "Composition.section.section",
        "sliceName" : "OtherAddictions",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:OtherAddictions.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Other addictions"
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:OtherAddictions.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72166-2",
              "display" : "Other addictions"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:OtherAddictions.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPatientHistory.section:OtherAddictions.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary",
        "path" : "Composition.section",
        "sliceName" : "sectionEncounterSummary",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67781-5",
              "display" : "Summarization of encounter note"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProblemList",
        "path" : "Composition.section.section",
        "sliceName" : "ProblemList",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProblemList.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Diagnostický souhrn"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProblemList.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11450-4",
              "display" : "Problem list"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProblemList.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProblemList.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProceduresAndTreatments",
        "path" : "Composition.section.section",
        "sliceName" : "ProceduresAndTreatments",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProceduresAndTreatments.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Výkony"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProceduresAndTreatments.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29554-3",
              "display" : "Procedure Narrative"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProceduresAndTreatments.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ProceduresAndTreatments.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicalDevices",
        "path" : "Composition.section.section",
        "sliceName" : "MedicalDevices",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicalDevices.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Zdravotní pomůcky a implantáty"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicalDevices.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "46264-8",
              "display" : "History of medical device use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicalDevices.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicalDevices.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicationDuring",
        "path" : "Composition.section.section",
        "sliceName" : "MedicationDuring",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicationDuring.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Medikace během ambulantního kontaktu"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicationDuring.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29549-3",
              "display" : "Medication administered Narrative"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicationDuring.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:MedicationDuring.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:Results",
        "path" : "Composition.section.section",
        "sliceName" : "Results",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:Results.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Výsledky vyšetření"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:Results.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "30954-2",
              "display" : "Relevant diagnostic tests/laboratory data note"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:Results.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:Results.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
              "http://hl7.org/fhir/StructureDefinition/ImagingStudy"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ClinicalSummary",
        "path" : "Composition.section.section",
        "sliceName" : "ClinicalSummary",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ClinicalSummary.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Klinické shrnutí"
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ClinicalSummary.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51848-0",
              "display" : "Evaluation note"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ClinicalSummary.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionEncounterSummary.section:ClinicalSummary.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/ClinicalImpression"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicationSummary",
        "path" : "Composition.section",
        "sliceName" : "sectionMedicationSummary",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionMedicationSummary.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionMedicationSummary.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10160-0",
              "display" : "History of medication use"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionMedicationSummary.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionMedicationSummary.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
              "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPlanOfCare",
        "path" : "Composition.section",
        "sliceName" : "sectionPlanOfCare",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18776-5",
              "display" : "Plan of care"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAttachments",
        "path" : "Composition.section",
        "sliceName" : "sectionAttachments",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAttachments.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAttachments.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "77599-9",
              "display" : "Additional documentation"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAttachments.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAttachments.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DocumentReference"]
          }
        ]
      }
    ]
  }
}

```
