# Bundle Outpatient Encounter Report (CZ) - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle Outpatient Encounter Report (CZ)**

## Resource Profile: Bundle Outpatient Encounter Report (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/cz-bundle-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:CZ_BundleAmb |

 
Clinical document used to represent a Outpatient Encounter Report for the scope of this guide. 

**Usages:**

* Examples for this Profile: [Bundle/OutpatientBundle-Mracena](Bundle-OutpatientBundle-Mracena.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/cz-bundle-amb)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bundle-amb.csv), [Excel](StructureDefinition-cz-bundle-amb.xlsx), [Schematron](StructureDefinition-cz-bundle-amb.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bundle-amb",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-bundle-amb",
  "version" : "0.1.0",
  "name" : "CZ_BundleAmb",
  "title" : "Bundle Outpatient Encounter Report (CZ)",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Outpatient Encounter Report for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Outpatient Encounter Report bundle",
        "definition" : "Outpatient Encounter Report bundle contains all resources that comprise content of the bundle.",
        "constraint" : [
          {
            "key" : "bdl-amb-1",
            "severity" : "error",
            "human" : "A document must have no additional Composition (including Composition subclass) resources besides the first.",
            "expression" : "entry.tail().where(resource is Composition).empty()",
            "source" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-bundle-amb"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "Instance identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "short" : "Instance identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Entry resources in the Outpatient Encounter Report bundle",
        "definition" : "An entry resource included in the Outpatient Encounter Report document bundle resource.",
        "comment" : "Must contain the Composition as the first entry (only a single Composition resource instance may be included). Additional constraints are specified in the HDR Composition profile.",
        "min" : 2
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://hl7.cz/fhir/amb/StructureDefinition/cz-composition-amb"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:allergyIntolerance",
        "path" : "Bundle.entry",
        "sliceName" : "allergyIntolerance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:allergyIntolerance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "https://hl7.cz/fhir/amb/StructureDefinition/cz-allergyintolerance-amb"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:device",
        "path" : "Bundle.entry",
        "sliceName" : "device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Device",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:deviceUseStatement",
        "path" : "Bundle.entry",
        "sliceName" : "deviceUseStatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:deviceUseStatement.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DeviceUseStatement",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:diagnosticReport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticReport",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:diagnosticReport.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "https://hl7.cz/fhir/img/StructureDefinition/cz-diagnostic-report"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Encounter",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:imagingStudy",
        "path" : "Bundle.entry",
        "sliceName" : "imagingStudy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:imagingStudy.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "ImagingStudy",
            "profile" : [
              "https://hl7.cz/fhir/img/StructureDefinition/cz-study-imaging"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:immunization",
        "path" : "Bundle.entry",
        "sliceName" : "immunization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:immunization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Immunization",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:media",
        "path" : "Bundle.entry",
        "sliceName" : "media",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:media.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Media"
          }
        ]
      },
      {
        "id" : "Bundle.entry:medication",
        "path" : "Bundle.entry",
        "sliceName" : "medication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medication.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Medication",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationRequest",
        "path" : "Bundle.entry",
        "sliceName" : "medicationRequest",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationRequest.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationStatement",
        "path" : "Bundle.entry",
        "sliceName" : "medicationStatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationStatement.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerRole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerRole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerRole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedure",
        "path" : "Bundle.entry",
        "sliceName" : "procedure",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedure.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation",
        "path" : "Bundle.entry",
        "sliceName" : "observation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation"
          }
        ]
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Specimen",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-specimen"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationDispense",
        "path" : "Bundle.entry",
        "sliceName" : "medicationDispense",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationDispense.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationDispense"
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationAdministration",
        "path" : "Bundle.entry",
        "sliceName" : "medicationAdministration",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationAdministration.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationAdministration"
          }
        ]
      },
      {
        "id" : "Bundle.entry:familyMemberHistory",
        "path" : "Bundle.entry",
        "sliceName" : "familyMemberHistory",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:familyMemberHistory.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "FamilyMemberHistory"
          }
        ]
      },
      {
        "id" : "Bundle.entry:documentReference",
        "path" : "Bundle.entry",
        "sliceName" : "documentReference",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:documentReference.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      },
      {
        "id" : "Bundle.entry:flag",
        "path" : "Bundle.entry",
        "sliceName" : "flag",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flag.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Flag",
            "profile" : ["https://hl7.cz/fhir/amb/StructureDefinition/cz-flag-amb"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:carePlan",
        "path" : "Bundle.entry",
        "sliceName" : "carePlan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:carePlan.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "CarePlan",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:goal",
        "path" : "Bundle.entry",
        "sliceName" : "goal",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:goal.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Goal"
          }
        ]
      },
      {
        "id" : "Bundle.entry:consent",
        "path" : "Bundle.entry",
        "sliceName" : "consent",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:consent.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Consent"
          }
        ]
      },
      {
        "id" : "Bundle.entry:provenance",
        "path" : "Bundle.entry",
        "sliceName" : "provenance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:provenance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Provenance",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-provenance"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Coverage",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Report Digital Signature"
      },
      {
        "id" : "Bundle.signature.type",
        "path" : "Bundle.signature.type",
        "short" : "Digital Signature Purposes"
      },
      {
        "id" : "Bundle.signature.when",
        "path" : "Bundle.signature.when",
        "short" : "When was signed"
      },
      {
        "id" : "Bundle.signature.who",
        "path" : "Bundle.signature.who",
        "short" : "Who signed."
      },
      {
        "id" : "Bundle.signature.data",
        "path" : "Bundle.signature.data",
        "short" : "Signature content"
      }
    ]
  }
}

```
