# A.2.7 - Outpatient stay - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.7 - Outpatient stay**

## Logical Model: A.2.7 - Outpatient stay 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogEnOutpatientStayCz |

 
Outpatient stay 

**Usages:**

* Use this Logical Model: [A - Outpatient Encounter Report](StructureDefinition-OutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/OutpatientStayCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-OutpatientStayCz.csv), [Excel](StructureDefinition-OutpatientStayCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OutpatientStayCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
  "version" : "0.1.0",
  "name" : "LogEnOutpatientStayCz",
  "title" : "A.2.7 - Outpatient stay",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Outpatient stay",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "OutpatientStayCz",
        "path" : "OutpatientStayCz",
        "short" : "A.2.7 - Outpatient stay",
        "definition" : "Outpatient stay"
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary",
        "path" : "OutpatientStayCz.diagnosticSummary",
        "short" : "A.2.7.1 - Diagnostický souhrn",
        "definition" : "Seznam diagnóz, příznaků a problémů relevantních pro daný ambulantní kontakt. Popisuje problémy aktivní v průběhu kontaktu nebo významné pro další péči; může být kódován i textově.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary.problemDetails",
        "path" : "OutpatientStayCz.diagnosticSummary.problemDetails",
        "short" : "A.2.7.1.2 - Kód",
        "definition" : "Formalizované vyjádření zdravotního problému kódem (např. MKN-10, MKN-O).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary.onsetDate",
        "path" : "OutpatientStayCz.diagnosticSummary.onsetDate",
        "short" : "A.2.7.1.3 - Datum vzniku",
        "definition" : "Datum vzniku onemocnění nebo příznaku, pokud je známo.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary.resolutionDate",
        "path" : "OutpatientStayCz.diagnosticSummary.resolutionDate",
        "short" : "A.2.7.1.4 - Datum vyřešení či remise",
        "definition" : "Datum remise nebo zlepšení, pokud je relevantní.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary.resolutionContext",
        "path" : "OutpatientStayCz.diagnosticSummary.resolutionContext",
        "short" : "A.2.7.1.5 - Okolnosti vyřešení",
        "definition" : "Důvod změny stavu problému na neaktivní (např. provedený výkon).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary.severity",
        "path" : "OutpatientStayCz.diagnosticSummary.severity",
        "short" : "A.2.7.1.6 - Závažnost",
        "definition" : "Subjektivní hodnocení závažnosti stavu klinikem (např. h7:condition-severity).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.diagnosticSummary.stage",
        "path" : "OutpatientStayCz.diagnosticSummary.stage",
        "short" : "A.2.7.1.7 - Stadium onemocnění",
        "definition" : "Stadium nebo grading problému podle zvolené klasifikace (např. TNM).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.problemDescription",
        "path" : "OutpatientStayCz.problemDescription",
        "short" : "A.2.7.1.1 - Popis problému",
        "definition" : "Popis problému textem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures",
        "path" : "OutpatientStayCz.significantProcedures",
        "short" : "A.2.7.2 - Výkony",
        "definition" : "Diagnostické a terapeutické výkony provedené v průběhu ambulantního kontaktu.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.procedureCode",
        "path" : "OutpatientStayCz.significantProcedures.procedureCode",
        "short" : "A.2.7.2.1 - Kód výkonu",
        "definition" : "Kód výkonu ve vybraném kódovém systému (SNOMED CT, ICHI apod.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.procedureDescription",
        "path" : "OutpatientStayCz.significantProcedures.procedureDescription",
        "short" : "A.2.7.2.2 - Popis procedury",
        "definition" : "Popis výkonu volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.bodySite",
        "path" : "OutpatientStayCz.significantProcedures.bodySite",
        "short" : "A.2.7.2.3 - Lokalizace",
        "definition" : "Anatomická lokalizace výkonu pomocí řízené terminologie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.performedDate",
        "path" : "OutpatientStayCz.significantProcedures.performedDate",
        "short" : "A.2.7.2.4 - Datum provedení",
        "definition" : "Datum provedení výkonu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.reasonPerformed",
        "path" : "OutpatientStayCz.significantProcedures.reasonPerformed",
        "short" : "A.2.7.2.5 - Důvod provedení",
        "definition" : "Důvod provedení výkonu textem nebo kódem (např. MKN-10).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.outcome",
        "path" : "OutpatientStayCz.significantProcedures.outcome",
        "short" : "A.2.7.2.6 - Výsledek",
        "definition" : "Formalizované vyjádření výsledku výkonu (procedure-outcome).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.complication",
        "path" : "OutpatientStayCz.significantProcedures.complication",
        "short" : "A.2.7.2.7 - Komplikace",
        "definition" : "Komplikace spojené s výkonem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantProcedures.targetDevice",
        "path" : "OutpatientStayCz.significantProcedures.targetDevice",
        "short" : "A.2.7.2.8 - Cílový zdravotnický prostředek",
        "definition" : "Odkaz na zdravotnický prostředek implantovaný nebo jinak využitý během výkonu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.medicalDevices",
        "path" : "OutpatientStayCz.medicalDevices",
        "short" : "A.2.7.3 - Zdravotní pomůcky a implantáty",
        "definition" : "Zavedené nebo použité zdravotní pomůcky relevantní pro ambulantní kontakt.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.medicalDevices.description",
        "path" : "OutpatientStayCz.medicalDevices.description",
        "short" : "A.2.7.3.1 - Popis zdravotnického prostředku",
        "definition" : "Popis zdravotnického prostředku (implantovaného či externího) textem a/nebo kódem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.medicalDevices.deviceIdentifier",
        "path" : "OutpatientStayCz.medicalDevices.deviceIdentifier",
        "short" : "A.2.7.3.2 - Identifikátor prostředku",
        "definition" : "Normalizovaný identifikátor, např. UDI.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.medicalDevices.insertionDate",
        "path" : "OutpatientStayCz.medicalDevices.insertionDate",
        "short" : "A.2.7.3.3 - Datum zavedení",
        "definition" : "Datum zavedení nebo první evidence prostředku relevantní pro kontakt.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.medicalDevices.removalDate",
        "path" : "OutpatientStayCz.medicalDevices.removalDate",
        "short" : "A.2.7.3.4 - Datum odstranění",
        "definition" : "Datum odstranění nebo ukončení užívání prostředku, pokud se vztahuje.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.medicalDevices.reasonForUse",
        "path" : "OutpatientStayCz.medicalDevices.reasonForUse",
        "short" : "A.2.7.3.5 - Důvod použití",
        "definition" : "Klinický důvod zavedení či použití zdravotnického prostředku.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy",
        "path" : "OutpatientStayCz.pharmacotherapy",
        "short" : "A.2.7.5 - Medikace",
        "definition" : "Vybraná medikamentózní léčba v průběhu ambulantního kontaktu nebo předepsaná při jeho ukončení.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.reason",
        "path" : "OutpatientStayCz.pharmacotherapy.reason",
        "short" : "A.2.7.5.1 - Indikace",
        "definition" : "Důvod podání/indikační důvod medikace (text nebo odkaz na problém).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.productCode",
        "path" : "OutpatientStayCz.pharmacotherapy.productCode",
        "short" : "A.2.7.5.2 - Kód SUKL",
        "definition" : "Kód léčiva dle databáze SÚKL, pokud je k dispozici.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.productName",
        "path" : "OutpatientStayCz.pharmacotherapy.productName",
        "short" : "A.2.7.5.3 - Název léčivého přípravku",
        "definition" : "Registrovaný název léčiva.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.activeIngredient",
        "path" : "OutpatientStayCz.pharmacotherapy.activeIngredient",
        "short" : "A.2.7.5.4 - Aktivní látky",
        "definition" : "Seznam aktivních látek (název a/nebo kód ATC/IDMP).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.strength",
        "path" : "OutpatientStayCz.pharmacotherapy.strength",
        "short" : "A.2.7.5.5 - Síla",
        "definition" : "Síla aktivní látky v přípravku (vyjádřeno v jednotkách).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.doseForm",
        "path" : "OutpatientStayCz.pharmacotherapy.doseForm",
        "short" : "A.2.7.5.6 - Forma léčiva",
        "definition" : "Léková forma (např. tableta, sirup).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.dosingInstructions",
        "path" : "OutpatientStayCz.pharmacotherapy.dosingInstructions",
        "short" : "A.2.7.5.7 - Dávkování",
        "definition" : "Frekvence a počet jednotek podání volným textem nebo formalizovaně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.route",
        "path" : "OutpatientStayCz.pharmacotherapy.route",
        "short" : "A.2.7.5.8 - Cesta podání",
        "definition" : "Cesta podání (např. per os, i.v.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.pharmacotherapy.period",
        "path" : "OutpatientStayCz.pharmacotherapy.period",
        "short" : "A.2.7.5.9 - Období podávání",
        "definition" : "Časový interval, kdy byla medikace podávána nebo je indikována.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults",
        "path" : "OutpatientStayCz.significantResults",
        "short" : "A.2.7.6 Výsledky vyšetření",
        "definition" : "Významné výsledky funkčních, diagnostických a zobrazovacích vyšetření, provedených během hospitalizace. Výsledky s nezpracovaným stavem („registered“) mají být uvedeny odděleně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults.date",
        "path" : "OutpatientStayCz.significantResults.date",
        "short" : "A.2.7.6.1 - Date",
        "definition" : "Date and time of the observation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults.status",
        "path" : "OutpatientStayCz.significantResults.status",
        "short" : "A.2.7.6.2 - Observation status",
        "definition" : "Status of the observation (e.g. registered, preliminary, final)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults.description",
        "path" : "OutpatientStayCz.significantResults.description",
        "short" : "A.2.7.6.3 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults.details",
        "path" : "OutpatientStayCz.significantResults.details",
        "short" : "A.2.7.6.4 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults.result",
        "path" : "OutpatientStayCz.significantResults.result",
        "short" : "A.2.7.6.5 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.significantResults.reporter",
        "path" : "OutpatientStayCz.significantResults.reporter",
        "short" : "A.2.7.6.7 - Reporter",
        "definition" : "With certain observation results, e.g. there may also be an interpreter or a person responsible for validation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.synthesis",
        "path" : "OutpatientStayCz.synthesis",
        "short" : "A.2.7.7 Klinické shrnutí",
        "definition" : "Podrobný popis důvodu a průběhu hospitalizace jako celku. Může být zakončeno klinickou úvahou (dif. dg., vysvětlení souvislostí) v klinicky složitých případech.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.synthesis.summaryProblem",
        "path" : "OutpatientStayCz.synthesis.summaryProblem",
        "short" : "A.2.7.7.1 Klinický souhrn problému",
        "definition" : "Souhrnný popis důvodu a průběhu ambulantního kontaktu za konkrétní problém.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.synthesis.problemDescription",
        "path" : "OutpatientStayCz.synthesis.problemDescription",
        "short" : "A.2.7.7.1.1 Popis problému",
        "definition" : "Popis problému textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.synthesis.reasonAndProgress",
        "path" : "OutpatientStayCz.synthesis.reasonAndProgress",
        "short" : "A.2.7.7.1.2 Důvod a průběh ambulantního kontaktu",
        "definition" : "Podrobný popis důvodu a průběhu ambulantního kontaktu za celý pobyt.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OutpatientStayCz.synthesis.clinicalThoughts",
        "path" : "OutpatientStayCz.synthesis.clinicalThoughts",
        "short" : "A.2.7.7.2 Klinická úvaha",
        "definition" : "Zakončení klinického shrnutí klinickou úvahou (diferenciální diagnostika, vysvětlení složitých stavů apod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
