# A - Outpatient Encounter Report - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A - Outpatient Encounter Report**

## Logical Model: A - Outpatient Encounter Report 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/OutpatientEncounterReportCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogEnOutpatientEncounterReportCz |

 
Outpatient Encounter Report 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/OutpatientEncounterReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-OutpatientEncounterReportCz.csv), [Excel](StructureDefinition-OutpatientEncounterReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OutpatientEncounterReportCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientEncounterReportCz",
  "version" : "0.1.0",
  "name" : "LogEnOutpatientEncounterReportCz",
  "title" : "A - Outpatient Encounter Report",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Outpatient Encounter Report",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientEncounterReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "OutpatientEncounterReportCz",
        "path" : "OutpatientEncounterReportCz",
        "short" : "A - Outpatient Encounter Report",
        "definition" : "Outpatient Encounter Report"
      },
      {
        "id" : "OutpatientEncounterReportCz.header",
        "path" : "OutpatientEncounterReportCz.header",
        "short" : "A.1 - Outpatient Encounter Report header data element",
        "definition" : "Outpatient Encounter Report header data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/HeaderAmbCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body",
        "path" : "OutpatientEncounterReportCz.body",
        "short" : "A.2 - Outpatient Encounter Report body data element",
        "definition" : "Outpatient Encounter Report body data element",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.advanceDirectives",
        "path" : "OutpatientEncounterReportCz.body.advanceDirectives",
        "short" : "A.2.1 - Advance directives",
        "definition" : "Advance directives",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/AdvanceDirectivesCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.alerts",
        "path" : "OutpatientEncounterReportCz.body.alerts",
        "short" : "A.2.2 - Alerts",
        "definition" : "Alerts",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/AlertsCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.encounter",
        "path" : "OutpatientEncounterReportCz.body.encounter",
        "short" : "A.2.3 - Encounter",
        "definition" : "Encounter ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/EncounterCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.admissionEvaluation",
        "path" : "OutpatientEncounterReportCz.body.admissionEvaluation",
        "short" : "A.2.4 - Admission evaluation",
        "definition" : "Admission evaluation - Admission status should be reported exceptionally only if it is relevant to ensure continuity of care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/AdmissionEvaluationCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.patientHistory",
        "path" : "OutpatientEncounterReportCz.body.patientHistory",
        "short" : "A.2.6 - Patient history",
        "definition" : "Patient history (might include information about provenance of the information)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/PatientHistoryCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.outpatientStay",
        "path" : "OutpatientEncounterReportCz.body.outpatientStay",
        "short" : "A.2.7 - Outpatient stay",
        "definition" : "Outpatient stay",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.medicationSummary",
        "path" : "OutpatientEncounterReportCz.body.medicationSummary",
        "short" : "A.2.8 - Discharge details",
        "definition" : "Discharge details (structured information should be provided, however if not available, at least a summary note should be present).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.recommendations",
        "path" : "OutpatientEncounterReportCz.body.recommendations",
        "short" : "A.2.9 - Care plan and other recommendations after discharge.",
        "definition" : "Care plan and other recommendations after discharge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.body.recommendations.carePlan",
        "path" : "OutpatientEncounterReportCz.body.recommendations.carePlan",
        "short" : "A.2.9.1 - Care plan",
        "definition" : "Care plan after discharge. Multiple care plans could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/PlanOfCareCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.presentedForm",
        "path" : "OutpatientEncounterReportCz.presentedForm",
        "short" : "A.3 - Presented Form",
        "definition" : "Entire order as issued. Various formats could be provided,  pdf format is recommended.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/PresentedFormCz"
          }
        ]
      },
      {
        "id" : "OutpatientEncounterReportCz.media",
        "path" : "OutpatientEncounterReportCz.media",
        "short" : "A.4 - Media Attachment",
        "definition" : "Aditional media attachment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/amb/StructureDefinition/AttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
