# A.1.9 - Digitální podpis - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.9 - Digitální podpis**

## Logical Model: A.1.9 - Digitální podpis 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/LogdigitalSignatureCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzDigitalSignatureCz |

 
Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/LogdigitalSignatureCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogdigitalSignatureCz.csv), [Excel](StructureDefinition-LogdigitalSignatureCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogdigitalSignatureCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/LogdigitalSignatureCz",
  "version" : "0.1.0",
  "name" : "LogCzDigitalSignatureCz",
  "title" : "A.1.9 - Digitální podpis",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/LogdigitalSignatureCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogdigitalSignatureCz",
        "path" : "LogdigitalSignatureCz",
        "short" : "A.1.9 - Digitální podpis",
        "definition" : "Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a"
      },
      {
        "id" : "LogdigitalSignatureCz.elektronickyPodpis56",
        "path" : "LogdigitalSignatureCz.elektronickyPodpis56",
        "short" : "A.1.9.1 - Elektronický podpis nebo pečeť",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "LogdigitalSignatureCz.casoveRazitko",
        "path" : "LogdigitalSignatureCz.casoveRazitko",
        "short" : "A.1.9.2 - Časové razítko",
        "definition" : "Elektronické časové razítko ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
