# A.1 - Header - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1 - Header**

## Logical Model: A.1 - Header 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/HeaderAmbCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogEnHeaderAmbCz |

 
Header with administrative data 

**Usages:**

* Use this Logical Model: [A - Outpatient Encounter Report](StructureDefinition-OutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/HeaderAmbCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HeaderAmbCz.csv), [Excel](StructureDefinition-HeaderAmbCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HeaderAmbCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/HeaderAmbCz",
  "version" : "0.1.0",
  "name" : "LogEnHeaderAmbCz",
  "title" : "A.1 - Header",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Header with administrative data",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/HeaderAmbCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HeaderAmbCz",
        "path" : "HeaderAmbCz",
        "short" : "A.1 - Header",
        "definition" : "Header with administrative data"
      },
      {
        "id" : "HeaderAmbCz.subject",
        "path" : "HeaderAmbCz.subject",
        "short" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "definition" : "Identification of the patient/subject and Patient/subject related contact information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.payer",
        "path" : "HeaderAmbCz.payer",
        "short" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.payer.insuranceCode",
        "path" : "HeaderAmbCz.payer.insuranceCode",
        "short" : "A.1.3.1 - Health insurance code",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.payer.insuranceName",
        "path" : "HeaderAmbCz.payer.insuranceName",
        "short" : "A.1.3.2 - Health insurance name",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.payer.insuranceNumber",
        "path" : "HeaderAmbCz.payer.insuranceNumber",
        "short" : "A.1.3.3 - Health insurance number",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient",
        "path" : "HeaderAmbCz.informationRecipient",
        "short" : "A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable",
        "definition" : "Information recipient - (intended recipient or recipients of the report), if applicable",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.identifier",
        "path" : "HeaderAmbCz.informationRecipient.identifier",
        "short" : "A.1.4.1 - Recipient identifier",
        "definition" : "The health professional or patient identifier. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier could be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.name",
        "path" : "HeaderAmbCz.informationRecipient.name",
        "short" : "A.1.4.2 - Recipient name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.organizationID",
        "path" : "HeaderAmbCz.informationRecipient.organizationID",
        "short" : "A.1.4.3 - Recipient organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.organization",
        "path" : "HeaderAmbCz.informationRecipient.organization",
        "short" : "A.1.4.4 - Recipient organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.address",
        "path" : "HeaderAmbCz.informationRecipient.address",
        "short" : "A.1.4.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.country",
        "path" : "HeaderAmbCz.informationRecipient.country",
        "short" : "A.1.4.6 - Country",
        "definition" : "Country of the intended recipient as part of the address.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.informationRecipient.telecom",
        "path" : "HeaderAmbCz.informationRecipient.telecom",
        "short" : "A.1.4.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated to a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.author",
        "path" : "HeaderAmbCz.author",
        "short" : "A.1.5 - Author (by whom the Outpatient report was/were authored). Multiple authors could be provided.",
        "definition" : "Author (by whom the Outpatient report was/were authored). Multiple authors could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.author.identifier",
        "path" : "HeaderAmbCz.author.identifier",
        "short" : "A.1.5.1 - Author identifier",
        "definition" : "The health professional identifier that will allow addressing recipients within a national or international data exchange infrastructure, such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.author.name",
        "path" : "HeaderAmbCz.author.name",
        "short" : "A.1.5.2 - Author name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.author.organizationID",
        "path" : "HeaderAmbCz.author.organizationID",
        "short" : "A.1.5.3 - Author organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.author.organization",
        "path" : "HeaderAmbCz.author.organization",
        "short" : "A.1.5.4 - Author organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.author.dateTime",
        "path" : "HeaderAmbCz.author.dateTime",
        "short" : "A.1.5.5 - Date Time",
        "definition" : "Date and time of the last modification of the document by its Author.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.attester",
        "path" : "HeaderAmbCz.attester",
        "short" : "A.1.6 - Attester (multiple attesters could be provided)",
        "definition" : "Attester (multiple attesters could be provided)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.attester.identifier",
        "path" : "HeaderAmbCz.attester.identifier",
        "short" : "A.1.6.1 - Attester identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.attester.name",
        "path" : "HeaderAmbCz.attester.name",
        "short" : "A.1.6.2 - Attester name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.attester.organizationID",
        "path" : "HeaderAmbCz.attester.organizationID",
        "short" : "A.1.6.3 - Attester organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.attester.organization",
        "path" : "HeaderAmbCz.attester.organization",
        "short" : "A.1.6.4 - Attester organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.attester.dateTime",
        "path" : "HeaderAmbCz.attester.dateTime",
        "short" : "A.1.6.5 - Approval date and time",
        "definition" : "Date and time of the approval of the document by Attester.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.legalAuthenticator",
        "path" : "HeaderAmbCz.legalAuthenticator",
        "short" : "A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document)",
        "definition" : "Legal authenticator (The person taking responsibility for the medical content of the document)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.legalAuthenticator.identifier",
        "path" : "HeaderAmbCz.legalAuthenticator.identifier",
        "short" : "A.1.7.1 - Legal authenticator identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. Multiple identifiers could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.legalAuthenticator.name",
        "path" : "HeaderAmbCz.legalAuthenticator.name",
        "short" : "A.1.7.2 - Legal authenticator name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.legalAuthenticator.organizationID",
        "path" : "HeaderAmbCz.legalAuthenticator.organizationID",
        "short" : "A.1.7.3 - Legal authenticator organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.legalAuthenticator.organization",
        "path" : "HeaderAmbCz.legalAuthenticator.organization",
        "short" : "A.1.7.4 - Legal authenticator organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.legalAuthenticator.dateTime",
        "path" : "HeaderAmbCz.legalAuthenticator.dateTime",
        "short" : "A.1.7.5 - Authentication date and time",
        "definition" : "Date and time when the document was authorised.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata",
        "path" : "HeaderAmbCz.documentMetadata",
        "short" : "A.1.8 - Document metadata",
        "definition" : "Document metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.identifier",
        "path" : "HeaderAmbCz.documentMetadata.identifier",
        "short" : "A.1.8.1 - Document ID",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.type",
        "path" : "HeaderAmbCz.documentMetadata.type",
        "short" : "A.1.8.2 - Document type",
        "definition" : "Identifies the type of document at hand, e.g. Outpatient report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.status",
        "path" : "HeaderAmbCz.documentMetadata.status",
        "short" : "A.1.8.3 - Document status",
        "definition" : "The status of the Outpatient report. E.g., preliminary, final.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.dateTime",
        "path" : "HeaderAmbCz.documentMetadata.dateTime",
        "short" : "A.1.8.4 - Report date and time",
        "definition" : "Date and time of the Outpatient report creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.title",
        "path" : "HeaderAmbCz.documentMetadata.title",
        "short" : "A.1.8.5 - Document title",
        "definition" : "Document title, fix value \"Outpatient report\".",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.custodian",
        "path" : "HeaderAmbCz.documentMetadata.custodian",
        "short" : "A.1.8.6 - Report custodian",
        "definition" : "Organisation that is in charge of maintaining the report [this element will include organisation ID, name, address etc., as other elements describing organisations].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.confidentiality",
        "path" : "HeaderAmbCz.documentMetadata.confidentiality",
        "short" : "A.1.8.7 - Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.language",
        "path" : "HeaderAmbCz.documentMetadata.language",
        "short" : "A.1.8.8 - Language",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.documentMetadata.version",
        "path" : "HeaderAmbCz.documentMetadata.version",
        "short" : "A.1.8.9 - Version",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderAmbCz.digitalSignature",
        "path" : "HeaderAmbCz.digitalSignature",
        "short" : "A.1.9 - Digital signature",
        "definition" : "Digital signature",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
