# CZ Patient Stay Model to this guide Map - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Patient Stay Model to this guide Map**

## ConceptMap: CZ Patient Stay Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ConceptMap/patientStay2FHIR-cz-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:PatientStay2FHIRCzAmb |

 
AMB Patient Stay Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "patientStay2FHIR-cz-amb",
  "url" : "https://hl7.cz/fhir/amb/ConceptMap/patientStay2FHIR-cz-amb",
  "version" : "0.1.0",
  "name" : "PatientStay2FHIRCzAmb",
  "title" : "CZ Patient Stay Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "AMB Patient Stay Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-composition-amb",
      "element" : [
        {
          "code" : "OutpatientStay.diagnosticSummary",
          "display" : "A.2.7.1 - Diagnostic summary",
          "target" : [
            {
              "code" : "Composition.section:sectionDiagnosticSummary",
              "equivalence" : "equivalent",
              "comment" : "Details in the Composition.section:sectionDiagnosticSummary.entry of type Condition. See dedicated group"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures",
          "display" : "A.2.7.2 - Significant procedures",
          "target" : [
            {
              "code" : "Composition.section:sectionSignificantProcedures",
              "equivalence" : "equivalent",
              "comment" : "Details in the Composition.section:sectionSignificantProcedures.entry of type Procedure. See dedicated group"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices",
          "display" : "A.2.7.3 - Medical devices and implants",
          "target" : [
            {
              "code" : "Composition.section:sectionMedicalDevices",
              "equivalence" : "equivalent",
              "comment" : "Details in the Composition.section:sectionMedicalDevices.entry of type DeviceUseStatement. See dedicated groups"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy",
          "display" : "A.2.7.5 - Pharmacotherapy",
          "target" : [
            {
              "code" : "Composition.section:sectionPharmacotherapy",
              "equivalence" : "relatedto",
              "comment" : "Details in the Composition.section:sectionPharmacotherapy.entry. See dedicated groups"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults",
          "display" : "A.2.7.6 - Significant Observation Results",
          "target" : [
            {
              "code" : "Composition.section:sectionSignificantResults",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.details",
          "display" : "A.2.7.6.4 - Observation details",
          "target" : [
            {
              "code" : "Composition.section:sectionSignificantResults.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.synthesis",
          "display" : "A.2.7.7 - Synthesis",
          "target" : [
            {
              "code" : "Composition.section:sectionSynthesis",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.synthesis.description",
          "display" : "A.2.7.7.1 - Problem synthesis",
          "target" : [
            {
              "code" : "Composition.section:sectionSynthesis.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.synthesis.reasoning",
          "display" : "A.2.7.7.2 - Clinical reasoning",
          "target" : [
            {
              "code" : "Composition.section:sectionSynthesis.text",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-condition-amb",
      "element" : [
        {
          "code" : "OutpatientStay.diagnosticSummary.problemDescription",
          "display" : "A.2.7.1.1 - Problem description",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.problemDetails",
          "display" : "A.2.7.1.2 - Problem details",
          "target" : [
            {
              "code" : "Condition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.onsetDate",
          "display" : "A.2.7.1.3 - Onset date",
          "target" : [
            {
              "code" : "Condition.onSetDateTime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.endDate",
          "display" : "A.2.7.1.4 - End date",
          "target" : [
            {
              "code" : "Condition.abatementDateTime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.category",
          "display" : "A.2.7.1.5 - Category",
          "target" : [
            {
              "code" : "Condition.category:poa",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.treatmentClass",
          "display" : "A.2.7.1.6 - Treatment class",
          "target" : [
            {
              "code" : "Condition.category:treated",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.clinicalStatus",
          "display" : "A.2.7.1.7 - Clinical status",
          "target" : [
            {
              "code" : "Condition.clinicalStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.resolution",
          "display" : "A.2.7.1.8 - Resolution circumstances",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto",
              "comment" : "The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.severity",
          "display" : "A.2.7.1.9 - Severity",
          "target" : [
            {
              "code" : "Condition.severity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.diagnosticSummary.stage",
          "display" : "A.2.7.1.10 - Stage",
          "target" : [
            {
              "code" : "Condition.stage",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
      "element" : [
        {
          "code" : "OutpatientStay.medicalDevices.description",
          "display" : "A.2.7.3.1 - Device and implant description",
          "target" : [
            {
              "code" : "Device.text",
              "equivalence" : "relatedto",
              "comment" : "if referring to the description of the device"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.identifier",
          "display" : "A.2.7.3.2 - Device ID",
          "target" : [
            {
              "code" : "Device.identifier",
              "equivalence" : "relatedto",
              "comment" : "if generic identifier"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.identifier",
          "display" : "A.2.7.3.2 - Device ID",
          "target" : [
            {
              "code" : "Device.udiCarrier",
              "equivalence" : "relatedto",
              "comment" : "if it is the udiCarrier"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-deviceUseStatement-amb",
      "element" : [
        {
          "code" : "OutpatientStay.medicalDevices.description",
          "display" : "A.2.7.3.1 - Device and implant description",
          "target" : [
            {
              "code" : "DeviceUseStatement.text",
              "equivalence" : "relatedto",
              "comment" : "if referring to the description of the usage of the device"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.implantDate",
          "display" : "A.2.7.3.3 - Implant date",
          "target" : [
            {
              "code" : "DeviceUseStatement.timing[x]",
              "equivalence" : "relatedto",
              "comment" : "If the usage period is highlighted"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.endDate",
          "display" : "A.2.7.3.4 - End date",
          "target" : [
            {
              "code" : "DeviceUseStatement.timingPeriod.end",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.reason",
          "display" : "A.2.7.3.5 - Reason",
          "target" : [
            {
              "code" : "DeviceUseStatement.reasonCode",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.reason",
          "display" : "A.2.7.3.5 - Reason",
          "target" : [
            {
              "code" : "DeviceUseStatement.reasonReference",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication",
      "element" : [
        {
          "code" : "OutpatientStay.pharmacotherapy.productCode",
          "display" : "A.2.7.5.2 - Code",
          "target" : [
            {
              "code" : "Medication.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.intendedUse",
          "display" : "A.2.7.5.3 - Intended use",
          "target" : [
            {
              "code" : "Composition.section:sectionPharmacotherapy",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.productName",
          "display" : "A.2.7.5.4 - Brand name",
          "target" : [
            {
              "code" : "Medication.extension:productName",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.activeIngredient",
          "display" : "A.2.7.5.5 - Active ingredient list",
          "target" : [
            {
              "code" : "Medication.ingredient.item[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.strength",
          "display" : "A.2.7.5.6 - Strength",
          "target" : [
            {
              "code" : "Medication.ingredient.strength",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.doseForm",
          "display" : "A.2.7.5.7 - Pharmaceutical dose form",
          "target" : [
            {
              "code" : "Medication.form",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-medicationDispense-amb",
      "element" : [
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationDispense.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationDispense.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.productCode",
          "display" : "A.2.7.5.2 - Code",
          "target" : [
            {
              "code" : "MedicationDispense.medicationCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-medicationRequest-amb",
      "element" : [
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationRequest.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationRequest.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.productCode",
          "display" : "A.2.7.5.2 - Code",
          "target" : [
            {
              "code" : "MedicationRequest.medicationCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-procedure-amb",
      "element" : [
        {
          "code" : "OutpatientStay.significantProcedures.procedureCode",
          "display" : "A.2.7.2.1 - Procedure code",
          "target" : [
            {
              "code" : "Procedure.code",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.description",
          "display" : "A.2.7.2.2 - Procedure description",
          "target" : [
            {
              "code" : "Procedure.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.bodySite",
          "display" : "A.2.7.2.3 - Body site",
          "target" : [
            {
              "code" : "Procedure.bodySite",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.bodySite",
          "display" : "A.2.7.2.3 - Body site",
          "target" : [
            {
              "code" : "Procedure.extension:bodySite",
              "equivalence" : "relatedto",
              "comment" : "if details about the body structure have to be provided"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.date",
          "display" : "A.2.7.2.4 - Procedure date",
          "target" : [
            {
              "code" : "Procedure.perfomedDateTime",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.reason",
          "display" : "A.2.7.2.5 - Procedure reason",
          "target" : [
            {
              "code" : "Procedure.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.reason",
          "display" : "A.2.7.2.5 - Procedure reason",
          "target" : [
            {
              "code" : "Procedure.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.outcome",
          "display" : "A.2.7.2.6 - Outcome",
          "target" : [
            {
              "code" : "Procedure.outcome",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.complication",
          "display" : "A.2.7.2.7 - Complication",
          "target" : [
            {
              "code" : "Procedure.complication",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.complication",
          "display" : "A.2.7.2.7 - Complication",
          "target" : [
            {
              "code" : "Procedure.complicationDetail",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantProcedures.focalDevice",
          "display" : "A.2.7.2.8 - Focal device",
          "target" : [
            {
              "code" : "Procedure.focalDevice",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.medicalDevices.implantDate",
          "display" : "A.2.7.3.3 - Implant date",
          "target" : [
            {
              "code" : "Procedure.perfomed[x]",
              "equivalence" : "relatedto",
              "comment" : "if the implantation procedure is described"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "element" : [
        {
          "code" : "OutpatientStay.significantResults.date",
          "display" : "A.2.7.6.1 - Date",
          "target" : [
            {
              "code" : "Observation.effective[x]",
              "equivalence" : "equivalent",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.status",
          "display" : "A.2.7.6.2 - Observation status",
          "target" : [
            {
              "code" : "Observation.status",
              "equivalence" : "equivalent",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.description",
          "display" : "A.2.7.6.3 - Result description",
          "target" : [
            {
              "code" : "Observation.text",
              "equivalence" : "relatedto",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.details",
          "display" : "A.2.7.6.4 - Observation details",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.result",
          "display" : "A.2.7.6.5 - Observation result",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "equivalent",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.result",
          "display" : "A.2.7.6.5 - Observation result",
          "target" : [
            {
              "code" : "Observation.component.value[x]",
              "equivalence" : "equivalent",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        },
        {
          "code" : "OutpatientStay.significantResults.reporter",
          "display" : "A.2.7.6.7 - Reporter",
          "target" : [
            {
              "code" : "Observation.performer",
              "equivalence" : "equivalent",
              "comment" : "Similar Mapping for other Observation profiles"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Dosage",
      "element" : [
        {
          "code" : "OutpatientStay.pharmacotherapy.dosageRegimen",
          "display" : "A.2.7.5.8 - Dosage Regimen",
          "target" : [
            {
              "code" : "Dosage",
              "equivalence" : "equivalent",
              "comment" : "MedicationDispense.dosageInstruction or MedicationRequest.dosageInstruction or MedicationStatement.dosage"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.route",
          "display" : "A.2.7.5.9 - Route of administration",
          "target" : [
            {
              "code" : "Dosage.route",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.period",
          "display" : "A.2.7.5.10 - Period of treatment",
          "target" : [
            {
              "code" : "Dosage.timing.repeat.duration",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
      "element" : [
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationAdministration.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationAdministration.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.productCode",
          "display" : "A.2.7.5.2 - Code",
          "target" : [
            {
              "code" : "MedicationAdministration.medicationCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.dosageRegimen",
          "display" : "A.2.7.5.8 - Dosage Regimen",
          "target" : [
            {
              "code" : "MedicationAdministration",
              "equivalence" : "relatedto",
              "comment" : "several elements used"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.route",
          "display" : "A.2.7.5.9 - Route of administration",
          "target" : [
            {
              "code" : "MedicationAdministration.dosage.route",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.period",
          "display" : "A.2.7.5.10 - Period of treatment",
          "target" : [
            {
              "code" : "MedicationAdministration.occurencePeriod",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/OutpatientStayCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
      "element" : [
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationStatement.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.reason",
          "display" : "A.2.7.5.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationStatement.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.productCode",
          "display" : "A.2.7.5.2 - Code",
          "target" : [
            {
              "code" : "MedicationStatement.medicationCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OutpatientStay.pharmacotherapy.period",
          "display" : "A.2.7.5.10 - Period of treatment",
          "target" : [
            {
              "code" : "MedicationStatement.effectivePeriod",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
