# CZ Medication Summary Model to this guide Map - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Medication Summary Model to this guide Map**

## ConceptMap: CZ Medication Summary Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ConceptMap/medicationSummary2FHIR-cz-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:MedicationSummary2FHIRCzAmb |

 
AMB Medication Summary Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "medicationSummary2FHIR-cz-amb",
  "url" : "https://hl7.cz/fhir/amb/ConceptMap/medicationSummary2FHIR-cz-amb",
  "version" : "0.1.0",
  "name" : "MedicationSummary2FHIRCzAmb",
  "title" : "CZ Medication Summary Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "AMB Medication Summary Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-Medication",
      "element" : [
        {
          "code" : "MedicationSummary.productCode",
          "display" : "A.2.9.2.3 - Code",
          "target" : [
            {
              "code" : "Medication.code",
              "equivalence" : "equivalent",
              "comment" : "Preferred mapping"
            }
          ]
        },
        {
          "code" : "MedicationSummary.productName",
          "display" : "A.2.9.2.4 - Brand name",
          "target" : [
            {
              "code" : "Medication.extension:productName",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "MedicationSummary.activeIngredient",
          "display" : "A.2.9.2.5 - Active ingredient list",
          "target" : [
            {
              "code" : "Medication.ingredient.item[x]",
              "equivalence" : "equal",
              "comment" : "Medication.ingredient.isActive = true"
            }
          ]
        },
        {
          "code" : "MedicationSummary.strength",
          "display" : "A.2.9.2.6 - Strength",
          "target" : [
            {
              "code" : "Medication.ingredient.strength",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicationSummary.doseForm",
          "display" : "A.2.9.2.7 - Pharmaceutical dose form",
          "target" : [
            {
              "code" : "Medication.form",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
      "element" : [
        {
          "code" : "MedicationSummary.productCode",
          "display" : "A.2.9.2.3 - Code",
          "target" : [
            {
              "code" : "MedicationDispense.medicationCodeableConcept",
              "equivalence" : "equivalent",
              "comment" : "If no details about the medication are provided"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-medicationRequest-amb",
      "element" : [
        {
          "code" : "MedicationSummary.reason",
          "display" : "A.2.9.2.1 - Medication reason",
          "target" : [
            {
              "code" : "MedicationRequest.status",
              "equivalence" : "equal",
              "comment" : "As reason for ordering"
            }
          ]
        },
        {
          "code" : "MedicationSummary.changeReason",
          "display" : "A.2.9.2.2 - Reason for change",
          "target" : [
            {
              "code" : "MedicationRequest.statusReason",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "MedicationSummary.productCode",
          "display" : "A.2.9.2.3 - Code",
          "target" : [
            {
              "code" : "MedicationRequest.medicationCodeableConcept",
              "equivalence" : "equivalent",
              "comment" : "If no details about the medication are provided"
            }
          ]
        },
        {
          "code" : "MedicationSummary.daysSupplied",
          "display" : "A.2.9.2.11 - Days supplied",
          "target" : [
            {
              "code" : "MedicationDispense.daysSupply",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Dosage",
      "element" : [
        {
          "code" : "MedicationSummary.dosageRegimen",
          "display" : "A.2.9.2.8 - Dosage Regimen",
          "target" : [
            {
              "code" : "Dosage",
              "equivalence" : "equivalent",
              "comment" : "MedicationRequest.dosageInstruction or MedicationDispense.dosageInstruction"
            }
          ]
        },
        {
          "code" : "MedicationSummary.route",
          "display" : "A.2.9.2.9 - Route of administration",
          "target" : [
            {
              "code" : "Dosage.route",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicationSummary.period",
          "display" : "A.2.9.2.10 - Period of treatment",
          "target" : [
            {
              "code" : "Dosage.timing.repeat.duration",
              "equivalence" : "equivalent",
              "comment" : "CHECK it is used the name period but the imression is that is the duration not the period"
            }
          ]
        }
      ]
    }
  ]
}

```
