# CZ Encounter Model to this guide Map - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Encounter Model to this guide Map**

## ConceptMap: CZ Encounter Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ConceptMap/encounter2FHIR-cz-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:Encounter2FHIRCzAmb |

 
AMB Encounter Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "encounter2FHIR-cz-amb",
  "url" : "https://hl7.cz/fhir/amb/ConceptMap/encounter2FHIR-cz-amb",
  "version" : "0.1.0",
  "name" : "Encounter2FHIRCzAmb",
  "title" : "CZ Encounter Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "AMB Encounter Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/InPatientEncounterCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
      "element" : [
        {
          "code" : "Encounter.admission.admitter.organizationID",
          "display" : "A.2.3.3.5 - Admitting organisation ID",
          "target" : [
            {
              "code" : "Organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "Encounter.participant.individual.ofType(PractitionerRole).organization and where participant.type is 'ADM'"
            }
          ]
        },
        {
          "code" : "Encounter.admission.referringHP.organizationID",
          "display" : "A.2.3.3.10 - Referring organisation ID",
          "target" : [
            {
              "code" : "Organization.identifier",
              "equivalence" : "relatedto",
              "comment" : "Encounter.participant.individual.ofType(PractitionerRole).organization and where participant.type is 'REF'"
            }
          ]
        },
        {
          "code" : "Encounter.location.organization.identifier",
          "display" : "A.2.3.6.2 - Organisation Part ID",
          "target" : [
            {
              "code" : "Organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "Encounter.location.location.managingOrganization"
            }
          ]
        },
        {
          "code" : "Encounter.location.organization.name",
          "display" : "A.2.3.6.3 - Organisation Part Name",
          "target" : [
            {
              "code" : "Organization.name",
              "equivalence" : "relatedto",
              "comment" : "Encounter.location.location.managingOrganization"
            }
          ]
        },
        {
          "code" : "Encounter.location.organization.details",
          "display" : "A.2.3.6.4 - Organisation Part Details",
          "target" : [
            {
              "code" : "Organization",
              "equivalence" : "relatedto",
              "comment" : "Encounter.location.location.managingOrganization; to be checked"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/InPatientEncounterCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
      "element" : [
        {
          "code" : "Encounter.admission.admitter.identifier",
          "display" : "A.2.3.3.3 - Admitting professional ID",
          "target" : [
            {
              "code" : "Practitioner.identifier",
              "equivalence" : "equivalent",
              "comment" : "Encounter.participant.individual.ofType(Practitioner) and where participant.type is 'ADM'"
            }
          ]
        },
        {
          "code" : "Encounter.admission.admitter.name",
          "display" : "A.2.3.3.4 - Admitting professional name",
          "target" : [
            {
              "code" : "Practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "Encounter.participant.individual.ofType(Practitioner) or\nEncounter.participant.individual.ofType(PractitionerRole).practitioner"
            }
          ]
        },
        {
          "code" : "Encounter.admission.referringHP.identifier",
          "display" : "A.2.3.3.8 - Referring professional ID",
          "target" : [
            {
              "code" : "Practitioner.identifier",
              "equivalence" : "equivalent",
              "comment" : "Encounter.participant.individual.ofType(Practitioner) and where participant.type is 'REF'"
            }
          ]
        },
        {
          "code" : "Encounter.admission.referringHP.name",
          "display" : "A.2.3.3.9 - Referring professional name",
          "target" : [
            {
              "code" : "Practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "Encounter.participant.individual.ofType(Practitioner) or\nEncounter.participant.individual.ofType(PractitionerRole).practitioner"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/InPatientEncounterCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "Encounter.admission.admitter.identifier",
          "display" : "A.2.3.3.3 - Admitting professional ID",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent",
              "comment" : "and where participant.type is 'ADM'"
            }
          ]
        },
        {
          "code" : "Encounter.admission.referringHP.identifier",
          "display" : "A.2.3.3.8 - Referring professional ID",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent",
              "comment" : "and where participant.type is 'REF'"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/InPatientEncounterCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-encounter-amb",
      "element" : [
        {
          "code" : "Encounter.type",
          "display" : "A.2.3.1 - Encounter type",
          "target" : [
            {
              "code" : "Encounter.class",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.note",
          "display" : "A.2.3.2 - Encounter note",
          "target" : [
            {
              "code" : "Encounter.extension:note",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admission",
          "display" : "A.2.3.3 - Admission",
          "target" : [
            {
              "code" : "Encounter",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admission.urgency",
          "display" : "A.2.3.3.1 - Admission urgency",
          "target" : [
            {
              "code" : "Encounter.priority",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Encounter.admission.date",
          "display" : "A.2.3.3.2 - Admission date",
          "target" : [
            {
              "code" : "Encounter.period.start",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admission.admitter",
          "display" : "Admitting professional",
          "target" : [
            {
              "code" : "Encounter.participant.individual",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'ADM'"
            }
          ]
        },
        {
          "code" : "Encounter.admission.admitter.organization",
          "display" : "A.2.3.3.6 - Admitting organisation",
          "target" : [
            {
              "code" : "Encounter.serviceProvider",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admission.admitter.organization",
          "display" : "A.2.3.3.6 - Admitting organisation",
          "target" : [
            {
              "code" : "Encounter.participant.individual.organization",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'ADM'  and Encounter.participant.individual.ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Encounter.admission.source",
          "display" : "A.2.3.3.7 - Admit Source",
          "target" : [
            {
              "code" : "Encounter.hospitalization.admitSource",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admission.referringHP",
          "display" : "Referring professional",
          "target" : [
            {
              "code" : "Encounter.participant.individual",
              "equivalence" : "equivalent",
              "comment" : "where participant.type is 'REF'"
            }
          ]
        },
        {
          "code" : "Encounter.admission.referringHP.organization",
          "display" : "A.2.3.3.11 - Referring organisation",
          "target" : [
            {
              "code" : "Encounter.participant.individual.organization",
              "equivalence" : "equal",
              "comment" : "where participant.type is 'REF'  and Encounter.participant.individual.ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Encounter.admissionReason",
          "display" : "A.2.3.4 - Admission reason",
          "target" : [
            {
              "code" : "Encounter.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admissionReason",
          "display" : "A.2.3.4 - Admission reason",
          "target" : [
            {
              "code" : "Encounter.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.admissionReason.code",
          "display" : "A.2.3.4.1 - Admission reason",
          "target" : [
            {
              "code" : "Encounter.reasonCode",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Encounter.admissionReason.comment",
          "display" : "A.2.3.4.2 - Admission reason comment",
          "target" : [
            {
              "code" : "Encounter.reasonCode.text",
              "equivalence" : "relatedto",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "Encounter.admissionReason.legalStatus",
          "display" : "A.2.3.4.3 - Admission legal status",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "to be checked"
            }
          ]
        },
        {
          "code" : "Encounter.discharge",
          "display" : "A.2.3.5 - Discharge",
          "target" : [
            {
              "code" : "Encounter",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Encounter.discharge.date",
          "display" : "A.2.3.5.1 - Discharge date",
          "target" : [
            {
              "code" : "Encounter.period.end",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Encounter.discharge.destinationType",
          "display" : "A.2.3.5.2 - Discharge destination type",
          "target" : [
            {
              "code" : "Encounter.hospitalization.dischargeDisposition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Encounter.discharge.destinationLocation",
          "display" : "A.2.3.5.3 - Destination location",
          "target" : [
            {
              "code" : "Encounter.hospitalization.destination",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Encounter.location",
          "display" : "A.2.3.6 - Location - All locations/departments where the patient stayed (was boarded) within the hospital.",
          "target" : [
            {
              "code" : "Encounter.location",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Encounter.location.period",
          "display" : "A.2.3.6.1 - Period",
          "target" : [
            {
              "code" : "Encounter.location.period",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amd/StructureDefinition/InPatientEncounterCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core",
      "element" : [
        {
          "code" : "Encounter.location.organization",
          "display" : "Organization",
          "target" : [
            {
              "code" : "Location.managingOrganization",
              "equivalence" : "equivalent",
              "comment" : "Encounter.location.location"
            }
          ]
        }
      ]
    }
  ]
}

```
