# CZ Alerts Model to this guide Map - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Alerts Model to this guide Map**

## ConceptMap: CZ Alerts Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ConceptMap/alerts2FHIR-cz-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:Alerts2FHIRCzAmb |

 
AMB Alerts Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "alerts2FHIR-cz-amb",
  "url" : "https://hl7.cz/fhir/amb/ConceptMap/alerts2FHIR-cz-amb",
  "version" : "0.1.0",
  "name" : "Alerts2FHIRCzAmb",
  "title" : "CZ Alerts Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "AMB Alerts Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/AlertsCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-allergyIntolerance-hdr",
      "element" : [
        {
          "code" : "Alerts.allergy",
          "display" : "A.2.2.1 - Allergy and Intolerance",
          "target" : [
            {
              "code" : "AllergyIntolerance",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.description",
          "display" : "A.2.2.1.1 - Allergy description",
          "target" : [
            {
              "code" : "AllergyIntolerance.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.agent",
          "display" : "A.2.2.1.2 - Agent or Allergen",
          "target" : [
            {
              "code" : "AllergyIntolerance.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.typeOfPropensity",
          "display" : "A.2.2.1.3 - Type of propensity",
          "target" : [
            {
              "code" : "AllergyIntolerance.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.manifestation",
          "display" : "A.2.2.1.4 - Allergy manifestation",
          "target" : [
            {
              "code" : "AllergyIntolerance.reaction.manifestation",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.criticality",
          "display" : "A.2.2.1.5 - Criticality",
          "target" : [
            {
              "code" : "AllergyIntolerance.criticality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.onsetDate",
          "display" : "A.2.2.1.6 - Onset date",
          "target" : [
            {
              "code" : "AllergyIntolerance.onset[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.endDate",
          "display" : "A.2.2.1.7 - End date",
          "target" : [
            {
              "code" : "AllergyIntolerance.extension:abatement-datetime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.status",
          "display" : "A.2.2.1.8 - Status",
          "target" : [
            {
              "code" : "AllergyIntolerance.clinicalStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.certainty",
          "display" : "A.2.2.1.9 - Certainty",
          "target" : [
            {
              "code" : "AllergyIntolerance.verificationStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Alerts.allergy.lastOccurrence",
          "display" : "A.2.2.1.10 - Last Occurence",
          "target" : [
            {
              "code" : "AllergyIntolerance.lastOccurrence",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/AlertsCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-compositionAmb",
      "element" : [
        {
          "code" : "Alerts.allergy",
          "display" : "A.2.2.1 - Allergy and Intolerance",
          "target" : [
            {
              "code" : "Composition.section:sectionAllergies",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts",
          "display" : "A.2.2.2 - Medical alerts (relevant for the respective hospital stay)",
          "target" : [
            {
              "code" : "Composition.section:sectionAlerts",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.description",
          "display" : "A.2.2.2.1 - Healthcare alert description",
          "target" : [
            {
              "code" : "Composition.section:sectionAlerts.text",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/AlertsCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr",
      "element" : [
        {
          "code" : "Alerts.medicalAlerts.description",
          "display" : "A.2.2.2.1 - Healthcare alert description",
          "target" : [
            {
              "code" : "Flag.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.description",
          "display" : "A.2.2.2.1 - Healthcare alert description",
          "target" : [
            {
              "code" : "Flag.code.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.code",
          "display" : "A.2.2.2.3 - Healthcare alert code(s)",
          "target" : [
            {
              "code" : "Flag.code",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked (cardinality)"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.specialistPhysician",
          "display" : "A.2.2.2.4 - Healthcare alert specialist physician",
          "target" : [
            {
              "code" : "Flag.author",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.comment",
          "display" : "A.2.2.2.5 - Healthcare alert comment",
          "target" : [
            {
              "code" : "Flag.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.priority",
          "display" : "A.2.2.2.6 - Healthcare alert priority",
          "target" : [
            {
              "code" : "Flag.extension:flagPriorityExt",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "Alerts.medicalAlerts.period",
          "display" : "A.2.2.2.7 - Healthcare alert period",
          "target" : [
            {
              "code" : "Flag.period",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        }
      ]
    }
  ]
}

```
