# CZ Advance Directives Model to this guide Map - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Advance Directives Model to this guide Map**

## ConceptMap: CZ Advance Directives Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ConceptMap/advanceDirectives2FHIR-cz-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:AdvanceDirectives2FHIRCzAmb |

 
AMB Advance Directives Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "advanceDirectives2FHIR-cz-amb",
  "url" : "https://hl7.cz/fhir/amb/ConceptMap/advanceDirectives2FHIR-cz-amb",
  "version" : "0.1.0",
  "name" : "AdvanceDirectives2FHIRCzAmb",
  "title" : "CZ Advance Directives Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "AMB Advance Directives Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/AdvanceDirectivesCz",
      "target" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-compositionAmb",
      "element" : [
        {
          "code" : "AdvanceDirectives.livingWill",
          "display" : "A.2.1.1 - Living will",
          "target" : [
            {
              "code" : "Composition.section:sectionAdvanceDirectives.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "AdvanceDirectives.livingWill",
          "display" : "A.2.1.1 - Living will",
          "target" : [
            {
              "code" : "Composition.section:sectionAdvanceDirectives.entry",
              "equivalence" : "equivalent",
              "comment" : "Composition.section:sectionAdvanceDirectives.entry.ofType(Consent)"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/amb/StructureDefinition/AdvanceDirectivesCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Consent",
      "element" : [
        {
          "code" : "AdvanceDirectives.livingWill.date",
          "display" : "A.2.1.1.1 - Date and time",
          "target" : [
            {
              "code" : "Consent.dateTime",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "AdvanceDirectives.livingWill.type",
          "display" : "A.2.1.1.2 - Type",
          "target" : [
            {
              "code" : "Consent.category",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "AdvanceDirectives.livingWill.comment",
          "display" : "A.2.1.1.3 - Comment",
          "target" : [
            {
              "code" : "Consent.text",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "AdvanceDirectives.livingWill.conditions",
          "display" : "A.2.1.1.4 - Related conditions",
          "target" : [
            {
              "code" : "Consent.provision.code",
              "equivalence" : "relatedto",
              "comment" : "TO BE checked"
            }
          ]
        },
        {
          "code" : "AdvanceDirectives.livingWill.document",
          "display" : "A.2.1.1.5 - Living will document",
          "target" : [
            {
              "code" : "Composition.section:sectionAdvanceDirectives.entry",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:sectionAdvanceDirectives.entry.ofType(DocumentReference)"
            }
          ]
        }
      ]
    }
  ]
}

```
