# Scope and content - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Scope and content**

## Scope and content

### Overview

### Dataset

Outpatient Encounter Report (OER) has two main components:

* Header and
* body.

**Header** contains basic administrative and identification data about the patient, healthcare providers and other key participants in the patient's care.

**Body** contains basic clinical data related to the patient's visit, treatment and treatment plan.

#### Header

The Header component of the outpatient report from the hospital provides documentation for:

* **Identification of the patient/subject:** This includes critical identification information like the patient's **given name**, **family name**, **date of birth**, and **national healthcare patient ID**. It also covers **nationality**, **gender**, and the patient’s **country of affiliation**.
* **Patient/subject related contact information:** This involves the patient’s **address** and **telecommunication contact details** (e.g., phone numbers and email addresses). It may also include details of a **preferred healthcare professional** (name, identifier, role, organization).
* **Health insurance and payment information:** Key data related to health insurance, including the **insurance code**, **name of the health insurance provider**, and the **patient's health insurance number**.
* **Information recipient:** Refers to the intended recipient of the outpatient encounter report. This includes **recipient's name**, **organization**, **address**, and **telecom details**.
* **Author:** Documents the **author of the report**, including their identifier (e.g., license number), name, and organizational information. The author is responsible for signing off on the content of the report.
* **Attester:** The healthcare professional who verifies the content of the report. This includes the **attester’s identifier**, **name**, **organization**, and the **date and time of attestation**.
* **Legal authenticator:** The person taking legal responsibility for the report. Includes the **identifier**, **name**, **organization**, and **date of authentication**.
* **Document metadata:** Contains the document's unique **identifier**, **type**, and metadata such as the **date and time** of creation or modification, ensuring proper tracking of the report.

#### Body

The Outpatient Encounter Report Body component includes:

* **Advance Directives:** Legal documents, such as wills or DNR orders, that guide treatment decisions.
* **Alerts:** Important medical alerts like allergies or other critical patient conditions.
* **Encounter:** Details of the visit, including the examination date, reason for the outpatient contact, and identification of the outpatient service provider.
* **Clinical Status at Presentation:** This section aims to concisely describe the patient's clinical status with emphasis on pathological manifestations. It is particularly important when the reason for the outpatient contact is an acute condition or deterioration of an existing underlying disease. The status upon admission should be documented exceptionally, only if it will be important for ensuring continuity of care.
* **Patient History:** Comprehensive record of the patient's medical history and anamnesis.
* **Encounter Summary** The course of the patient during the visit, including treatment and procedures.
* **Medication Summary:** A consolidated overview of medications recommended for the post-discharge period, specifying whether the medication is continued, modified, newly initiated, or discontinued. In contrast to previous practice, this overview also includes discontinued medications.
* **Plan of Care:** Follow-up care plan and recommendations.

