# Artifacts Summary - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Actors and Obligations (Informative) 

Actors and Obligations used to describe the Outpatient Encounter Report functional requirements for the specified data elements. Informative for this version of the guide.

| | |
| :--- | :--- |
| [Flag Obligations (AMB CZ)](StructureDefinition-cz-flag-obl-amb.md) | This profile defines the obligations for the CZ_FlagAmb profile used in the Amb CZ project. |

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md) | Ambulantní zpráva |
| [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderAmbCz.md) | Záhlaví dokumentu s administrativními údaji |
| [A.2.1 - Dříve vyslovená přání](StructureDefinition-logAdvanceDirectivesCz.md) | Ambulantní zpráva - Dříve vyslovená přání |
| [A.2.2 - Urgentní informace](StructureDefinition-logAlertsCz.md) | Urgentní informace |
| [A.2.3 - Údaje o ambulantním kontaktu](StructureDefinition-logEncounterCz.md) | Záznam o ambulantním kontaktu v rámci ambulantní zprávy. |
| [A.2.4 - Stav při přijetí](StructureDefinition-logAdmissionEvaluationCz.md) | Stav při přijetí (Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče.) |
| [A.2.6 - Anamnéza pacienta](StructureDefinition-logPatientHistoryCz.md) | Anamnéza pacienta |
| [A.2.7 - Průběh ambulantního kontaktu](StructureDefinition-logOutpatientStayCz.md) | Popis průběhu ambulantního kontaktu zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí. |
| [A.2.8 - Souhrn medikace](StructureDefinition-logMedicationSummaryCz.md) | Souhrnná informace o medikaci, doporučené na období po propuštění, s vyznačením, zda se jedná o medikaci pokračující, změněnou či nově zahájenou. |
| [A.2.9.1 - Plán péče](StructureDefinition-logPlanOfCareCz.md) | Plán péče po ambulantním kontaktu |
| [A.3 - Prezentační forma](StructureDefinition-logPresentedFormCz.md) | Ambulantní zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy. |
| [A.4 - Ostatní přílohy](StructureDefinition-logAttachmentsCz.md) | Ostatní přílohy |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Outpatient Encounter Report](StructureDefinition-OutpatientEncounterReportCz.md) | Outpatient Encounter Report |
| [A.1 - Header](StructureDefinition-HeaderAmbCz.md) | Header with administrative data |
| [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) | Outpatient Report - Outpatient Report subject data element - A.1.1 and A.1.2 eHN |
| [A.1.1 - Identifikace a A.1.2 - informace o pacientovi](StructureDefinition-LogSubjectCz.md) | Ambulantní zpráva - Informace o pacientovi. |
| [A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md) | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [A.1.9 - Digitální podpis](StructureDefinition-LogdigitalSignatureCz.md) | Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a |
| [A.2.1 - Advance Directives](StructureDefinition-AdvanceDirectivesCz.md) | Advance Directives |
| [A.2.2 - Alerts](StructureDefinition-AlertsCz.md) | Alerts |
| [A.2.3 - Encounter](StructureDefinition-EncounterCz.md) | Encounter |
| [A.2.4 - Admission Evaluation](StructureDefinition-AdmissionEvaluationCz.md) | Admission Evaluation |
| [A.2.6 - Patient History](StructureDefinition-PatientHistoryCz.md) | Patient History |
| [A.2.7 - Outpatient stay](StructureDefinition-OutpatientStayCz.md) | Outpatient stay |
| [A.2.8 - Medication Summary](StructureDefinition-MedicationSummaryCz.md) | Medication Summary |
| [A.2.9.1 - Plan of Care](StructureDefinition-PlanOfCareCz.md) | Plan of Care |
| [A.3 - Presented Form](StructureDefinition-PresentedFormCz.md) | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [A.4 - Attachments](StructureDefinition-AttachmentsCz.md) | Attachments |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AllergyIntolerance: Outpatient Encounter Report (CZ)](StructureDefinition-cz-allergyintolerance-amb.md) | AllergyIntolerance resource to represent information about allergies or intolerances relevant to ambulatory care in the scope of this guide. |
| [Bundle Outpatient Encounter Report (CZ)](StructureDefinition-cz-bundle-amb.md) | Clinical document used to represent a Outpatient Encounter Report for the scope of this guide. |
| [Composition: Outpatient Encounter Report (CZ)](StructureDefinition-cz-composition-amb.md) | Clinical document used to represent an Outpatient Encounter Report for the scope of this guide. |
| [Encounter (AMB CZ)](StructureDefinition-cz-encounter-amb.md) | This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide. |
| [Flag: Outpatient Encounter Report (CZ)](StructureDefinition-cz-flag-amb.md) | Flag resource to represent important clinical or administrative information about the patient relevant to ambulatory care in the scope of this guide. |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Admition Evaluation Model to this guide Map](ConceptMap-admitionEvaluation2FHIR-cz-amb.md) | AMB Admition Evaluation Model to this guide mapping |
| [CZ Advance Directives Model to this guide Map](ConceptMap-advanceDirectives2FHIR-cz-amb.md) | AMB Advance Directives Model to this guide mapping |
| [CZ Alerts Model to this guide Map](ConceptMap-alerts2FHIR-cz-amb.md) | AMB Alerts Model to this guide mapping |
| [CZ Attachement Model to this guide Map](ConceptMap-attachement2FHIR-cz-amb.md) | AMB Attachement Model to this guide mapping |
| [CZ Encounter Model to this guide Map](ConceptMap-encounter2FHIR-cz-amb.md) | AMB Encounter Model to this guide mapping |
| [CZ Header Model to this guide Map](ConceptMap-header2FHIR-cz-amb.md) | AMB Header Model to this guide mapping |
| [CZ Medication Summary Model to this guide Map](ConceptMap-medicationSummary2FHIR-cz-amb.md) | AMB Medication Summary Model to this guide mapping |
| [CZ Patient History Model to this guide Map](ConceptMap-patientHistory2FHIR-cz-amb.md) | AMB Patient History Model to this guide mapping |
| [CZ Patient Stay Model to this guide Map](ConceptMap-patientStay2FHIR-cz-amb.md) | AMB Patient Stay Model to this guide mapping |
| [CZ Plan of Care Model to this guide Map](ConceptMap-planOfCare2FHIR-cz-amb.md) | AMB Plan of Care Model to this guide mapping |
| [CZ Presented Form Model to this guide Map](ConceptMap-presentedForm2FHIR-cz-amb.md) | AMB Presented Form Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Ambulantní zpráva](Composition-698056a8-57a6-49ed-909e-ea4216b18a6d.md) | Example Composition for Outpatient Report for patient Mrakomorová Mračena |
| [OutpatientBundle-Mracena](Bundle-OutpatientBundle-Mracena.md) | Example Bundle for Outpatient Report for patient Mrakomorová Mračena |
| [Patient-Mracena](Patient-00d304b8-5839-43dd-9239-69aed544f7e1.md) | Patient, contact information and practitioner |
| [Practitioner-123456789](Practitioner-161dcf7e-928b-437a-a310-6c61038e6ff9.md) | Practitioner id(KRZP)=123456789 |

