# A.2.9.1 - Plán péče - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.9.1 - Plán péče**

## Logical Model: A.2.9.1 - Plán péče 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logPlanOfCareCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzPlanOfCareCz |

 
Plán péče po ambulantním kontaktu 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logPlanOfCareCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logPlanOfCareCz.csv), [Excel](StructureDefinition-logPlanOfCareCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logPlanOfCareCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logPlanOfCareCz",
  "version" : "0.1.0",
  "name" : "LogCzPlanOfCareCz",
  "title" : "A.2.9.1 - Plán péče",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Plán péče po ambulantním kontaktu",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logPlanOfCareCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logPlanOfCareCz",
        "path" : "logPlanOfCareCz",
        "short" : "A.2.9.1 - Plán péče",
        "definition" : "Plán péče po ambulantním kontaktu"
      },
      {
        "id" : "logPlanOfCareCz.nazev",
        "path" : "logPlanOfCareCz.nazev",
        "short" : "A.2.9.1.1 Název",
        "definition" : "...Název plánu péče, např. 'Plán péče po endoprotéze kyčelního kloubu'...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.resi",
        "path" : "logPlanOfCareCz.resi",
        "short" : "A.2.9.1.2 Řeší",
        "definition" : "...Onemocnění či stavy, na které se plán vztahuje. Vybere lékař ze seznamu zdravotních problémů uvedených v diagnostickém souhrnu...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.popis",
        "path" : "logPlanOfCareCz.popis",
        "short" : "A.2.9.1.3 Popis doporučení",
        "definition" : "...Popis typu a povahy plánu péče...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.obdobi",
        "path" : "logPlanOfCareCz.obdobi",
        "short" : "A.2.9.1.4 Období",
        "definition" : "...Období, ve kterém by měl být plán péče realizován...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.podrobnosti",
        "path" : "logPlanOfCareCz.podrobnosti",
        "short" : "A.2.9.1.5 Další podrobnosti plánu",
        "definition" : "...Další strukturované informace popisující cíle plánu, složení terapeutického týmu apod...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.aktivity",
        "path" : "logPlanOfCareCz.aktivity",
        "short" : "A.2.9.1.6 Aktivity",
        "definition" : "...Jednotlivé aktivity plánu...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.aktivity.typ",
        "path" : "logPlanOfCareCz.aktivity.typ",
        "short" : "A.2.9.1.6.1 Typ aktivity",
        "definition" : "...Popis aktivity léčebného plánu. Např. doporučená medikace, požadovaná vyšetření, požadavky na komunikaci, dietní doporučení, režimová opatření, plánované kontroly apod...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.aktivity.popis",
        "path" : "logPlanOfCareCz.aktivity.popis",
        "short" : "A.2.9.1.6.2 Popis aktivity",
        "definition" : "...Detailní popis plánované aktivity volným textem...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPlanOfCareCz.aktivity.atributy",
        "path" : "logPlanOfCareCz.aktivity.atributy",
        "short" : "A.2.9.1.6.3 Specifické atributy",
        "definition" : "...Specifické atributy pro jednotlivé typy aktivit...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
