# A.1 - Hlavička dokumentu - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1 - Hlavička dokumentu**

## Logical Model: A.1 - Hlavička dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logHeaderAmbCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzHeaderAmbCz |

 
Záhlaví dokumentu s administrativními údaji 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logHeaderAmbCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logHeaderAmbCz.csv), [Excel](StructureDefinition-logHeaderAmbCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logHeaderAmbCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logHeaderAmbCz",
  "version" : "0.1.0",
  "name" : "LogCzHeaderAmbCz",
  "title" : "A.1 - Hlavička dokumentu",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Záhlaví dokumentu s administrativními údaji",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logHeaderAmbCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logHeaderAmbCz",
        "path" : "logHeaderAmbCz",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Záhlaví dokumentu s administrativními údaji"
      },
      {
        "id" : "logHeaderAmbCz.pacient",
        "path" : "logHeaderAmbCz.pacient",
        "short" : "A.1.1 Identifikace pacienta",
        "definition" : "Identifikace pacienta – křestní jméno, příjmení, datum narození, identifikátory, státní občanství, úřední pohlaví, komunikační jazyk.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.jmeno",
        "path" : "logHeaderAmbCz.pacient.jmeno",
        "short" : "A.1.1.1 Křestní jméno",
        "definition" : "Křestní jméno pacienta.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.prijmeni",
        "path" : "logHeaderAmbCz.pacient.prijmeni",
        "short" : "A.1.1.2 Příjmení",
        "definition" : "Příjmení pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.datumNarozeni",
        "path" : "logHeaderAmbCz.pacient.datumNarozeni",
        "short" : "A.1.1.3 Datum narození",
        "definition" : "Datum, případně i čas narození pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.idPacienta",
        "path" : "logHeaderAmbCz.pacient.idPacienta",
        "short" : "A.1.1.4 Identifikátor pacienta",
        "definition" : "Unikátní identifikátor osoby – RID, DRID, číslo pasu atd.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.narodnost",
        "path" : "logHeaderAmbCz.pacient.narodnost",
        "short" : "A.1.1.5 Státní občanství",
        "definition" : "Státní občanství podle zákona 186/2013 Sb.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.pohlavi",
        "path" : "logHeaderAmbCz.pacient.pohlavi",
        "short" : "A.1.1.6 Úřední pohlaví",
        "definition" : "Administrativní pohlaví podle dokladů.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pacient.jazyk",
        "path" : "logHeaderAmbCz.pacient.jazyk",
        "short" : "A.1.1.7 Komunikační jazyk",
        "definition" : "Jazyk nebo jazyky, jimiž pacient komunikuje.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt",
        "path" : "logHeaderAmbCz.kontakt",
        "short" : "A.1.2 Kontaktní informace pacienta",
        "definition" : "Kontaktní údaje pacienta, včetně adresy, kontaktů a preferovaného lékaře.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.adresa",
        "path" : "logHeaderAmbCz.kontakt.adresa",
        "short" : "A.1.2.1 Adresa",
        "definition" : "Poštovní adresa (řádky adresy, město, PSČ, země).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.telefon",
        "path" : "logHeaderAmbCz.kontakt.telefon",
        "short" : "A.1.2.2 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar",
        "short" : "A.1.2.3 Preferovaný lékař",
        "definition" : "Identifikace preferovaného lékaře, u kterého je pacient evidován.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar.idLekare",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar.idLekare",
        "short" : "A.1.2.3.1 Identifikátor lékaře",
        "definition" : "Identifikační číslo lékaře dle NR-ZP.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar.jmenoLekare",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar.jmenoLekare",
        "short" : "A.1.2.3.2 Jméno lékaře",
        "definition" : "Plné jméno lékaře.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar.specializace",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar.specializace",
        "short" : "A.1.2.3.3 Specializace",
        "definition" : "Specializace lékaře podle číselníku NR-ZP.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar.idPoskytovatele",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar.idPoskytovatele",
        "short" : "A.1.2.3.4 ID a název poskytovatele",
        "definition" : "Identifikátor a název poskytovatele, kterého lékař reprezentuje.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "short" : "A.1.2.3.5 Adresa poskytovatele",
        "definition" : "Poštovní adresa poskytovatele zdravotní péče.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "path" : "logHeaderAmbCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "short" : "A.1.2.3.6 Telekomunikační kontakt",
        "definition" : "Telefon nebo e-mail poskytovatele.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba",
        "short" : "A.1.2.4 Zákonný zástupce a kontaktní osoba",
        "definition" : "Kontaktní osoba – např. zákonný zástupce nebo jiná blízká osoba.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.typ",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.typ",
        "short" : "A.1.2.4.1 Typ kontaktu",
        "definition" : "Typ kontaktní osoby – zákonný zástupce, emergentní kontakt apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.vztah",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.vztah",
        "short" : "A.1.2.4.2 Vztah k pacientovi",
        "definition" : "Rodinný nebo jiný vztah ke kontaktované osobě.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.idOsoby",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.idOsoby",
        "short" : "A.1.2.4.3 Id osoby",
        "definition" : "Unikátní identifikátor kontaktní osoby.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.jmeno",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.jmeno",
        "short" : "A.1.2.4.4 Křestní jméno",
        "definition" : "Křestní jméno kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.prijmeni",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.prijmeni",
        "short" : "A.1.2.4.5 Příjmení",
        "definition" : "Příjmení kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.adresa",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.adresa",
        "short" : "A.1.2.4.6 Adresa kontaktní osoby",
        "definition" : "Adresa kontaktní osoby.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.kontakt.kontaktniOsoba.kontakt",
        "path" : "logHeaderAmbCz.kontakt.kontaktniOsoba.kontakt",
        "short" : "A.1.2.4.7 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pojistovna",
        "path" : "logHeaderAmbCz.pojistovna",
        "short" : "A.1.3 Zdravotní pojištění",
        "definition" : "Informace o pojištění pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pojistovna.kodPojistovny",
        "path" : "logHeaderAmbCz.pojistovna.kodPojistovny",
        "short" : "A.1.3.1 Kód zdravotní pojišťovny",
        "definition" : "Kód zdravotní pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pojistovna.nazev",
        "path" : "logHeaderAmbCz.pojistovna.nazev",
        "short" : "A.1.3.2 Název zdravotní pojišťovny",
        "definition" : "Oficiální název pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.pojistovna.cisloPojistence",
        "path" : "logHeaderAmbCz.pojistovna.cisloPojistence",
        "short" : "A.1.3.3 Číslo zdravotního pojištění",
        "definition" : "Číslo pojištěnce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.prijemce",
        "path" : "logHeaderAmbCz.prijemce",
        "short" : "A.1.4 Příjemce dokumentu",
        "definition" : "Zamýšlený příjemce propouštěcí zprávy.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.prijemce.idPrijemce",
        "path" : "logHeaderAmbCz.prijemce.idPrijemce",
        "short" : "A.1.4.1 ID příjemce",
        "definition" : "Identifikační číslo zdravotnického pracovníka nebo osobní identifikátor pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.prijemce.jmeno",
        "path" : "logHeaderAmbCz.prijemce.jmeno",
        "short" : "A.1.4.2 Jméno příjemce",
        "definition" : "Jméno a příjmení osoby příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.prijemce.idOrganizace",
        "path" : "logHeaderAmbCz.prijemce.idOrganizace",
        "short" : "A.1.4.3 ID organizace příjemce",
        "definition" : "Identifikátor organizace příjemce (např. NRPZS, IČO).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.prijemce.organizace",
        "path" : "logHeaderAmbCz.prijemce.organizace",
        "short" : "A.1.4.4 Organizace příjemce",
        "definition" : "Název a identifikační údaje zařízení nebo pracoviště příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.autor",
        "path" : "logHeaderAmbCz.autor",
        "short" : "A.1.5 Autor dokumentu",
        "definition" : "Osoba nebo systém, který dokument vytvořil.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.autor.idAutor",
        "path" : "logHeaderAmbCz.autor.idAutor",
        "short" : "A.1.5.1 Identifikátor autora",
        "definition" : "Identifikační číslo autora (zdravotnický pracovník nebo IS).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.autor.jmeno",
        "path" : "logHeaderAmbCz.autor.jmeno",
        "short" : "A.1.5.2 Jméno autora",
        "definition" : "Jméno osoby nebo systému, který dokument sestavil.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.autor.idOrganizace",
        "path" : "logHeaderAmbCz.autor.idOrganizace",
        "short" : "A.1.5.3 ID organizace",
        "definition" : "Identifikátor organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.autor.organizace",
        "path" : "logHeaderAmbCz.autor.organizace",
        "short" : "A.1.5.4 Organizace autora",
        "definition" : "Název organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.autor.datum",
        "path" : "logHeaderAmbCz.autor.datum",
        "short" : "A.1.5.5 Datum a čas uložení",
        "definition" : "Datum a čas poslední modifikace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.overil",
        "path" : "logHeaderAmbCz.overil",
        "short" : "A.1.6 Ověřil",
        "definition" : "Zdravotnický pracovník, který dokument ověřil.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.overil.idOveril",
        "path" : "logHeaderAmbCz.overil.idOveril",
        "short" : "A.1.6.1 Identifikátor ověřovatele",
        "definition" : "Identifikační číslo ověřovatele dokumentu.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.overil.jmeno",
        "path" : "logHeaderAmbCz.overil.jmeno",
        "short" : "A.1.6.2 Jméno ověřovatele",
        "definition" : "Plné jméno ověřující osoby.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.overil.idOrganizace",
        "path" : "logHeaderAmbCz.overil.idOrganizace",
        "short" : "A.1.6.3 ID organizace",
        "definition" : "Identifikátor organizace ověřovatele.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.overil.organizace",
        "path" : "logHeaderAmbCz.overil.organizace",
        "short" : "A.1.6.4 Organizace ověřovatele",
        "definition" : "Název organizace, kterou ověřovatel reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.overil.datum",
        "path" : "logHeaderAmbCz.overil.datum",
        "short" : "A.1.6.5 Datum a čas ověření",
        "definition" : "Datum a čas ověření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.zodpovida",
        "path" : "logHeaderAmbCz.zodpovida",
        "short" : "A.1.7 Zodpovídá",
        "definition" : "Zdravotnický pracovník zodpovědný za obsah dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.zodpovida.idZodpovida",
        "path" : "logHeaderAmbCz.zodpovida.idZodpovida",
        "short" : "A.1.7.1 Zodpovídá - ID",
        "definition" : "Identifikátor osoby zodpovědné za dokument.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.zodpovida.jmeno",
        "path" : "logHeaderAmbCz.zodpovida.jmeno",
        "short" : "A.1.7.2 Zodpovídá - jméno osoby",
        "definition" : "Plné jméno osoby zodpovědné za dokument.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.zodpovida.organizace",
        "path" : "logHeaderAmbCz.zodpovida.organizace",
        "short" : "A.1.7.3 Zodpovídá - organizace",
        "definition" : "Organizace reprezentovaná odpovědnou osobou.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.zodpovida.datum",
        "path" : "logHeaderAmbCz.zodpovida.datum",
        "short" : "A.1.7.4 Datum a čas autorizace",
        "definition" : "Datum a čas autorizace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata",
        "path" : "logHeaderAmbCz.metadata",
        "short" : "A.1.8 Metadata dokumentu",
        "definition" : "Technická metadata dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.dokumentId",
        "path" : "logHeaderAmbCz.metadata.dokumentId",
        "short" : "A.1.8.1 ID dokumentu",
        "definition" : "Jedinečný identifikátor dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.kategorie",
        "path" : "logHeaderAmbCz.metadata.kategorie",
        "short" : "A.1.8.2 Kategorie dokumentu",
        "definition" : "Kategorie EHR (např. propouštěcí zpráva).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.stav",
        "path" : "logHeaderAmbCz.metadata.stav",
        "short" : "A.1.8.3 Stav dokumentu",
        "definition" : "Stav dokumentu – předběžný, finální apod.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.vytvoreni",
        "path" : "logHeaderAmbCz.metadata.vytvoreni",
        "short" : "A.1.8.4 Datum a čas vytvoření",
        "definition" : "Datum a čas vytvoření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.nazevDokumentu",
        "path" : "logHeaderAmbCz.metadata.nazevDokumentu",
        "short" : "A.1.8.5 Název dokumentu",
        "definition" : "Název dokumentu, např. „Propouštěcí zpráva“.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.spravce",
        "path" : "logHeaderAmbCz.metadata.spravce",
        "short" : "A.1.8.6 Správce dokumentu",
        "definition" : "Technický správce dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.duveryhodnost",
        "path" : "logHeaderAmbCz.metadata.duveryhodnost",
        "short" : "A.1.8.7 Důvěrnost dokumentu",
        "definition" : "Stupeň důvěrnosti dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.jazyk",
        "path" : "logHeaderAmbCz.metadata.jazyk",
        "short" : "A.1.8.8 Jazyk dokumentu",
        "definition" : "Jazyk dokumentu dle ISO kódu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.metadata.verze",
        "path" : "logHeaderAmbCz.metadata.verze",
        "short" : "A.1.8.9 Verze",
        "definition" : "Verze dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.podpis",
        "path" : "logHeaderAmbCz.podpis",
        "short" : "A.1.9 Elektronické podpisy",
        "definition" : "Elektronické podepsání dokumentu dle zákona.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.podpis.elektronickyPodpis",
        "path" : "logHeaderAmbCz.podpis.elektronickyPodpis",
        "short" : "A.1.9.1 Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logHeaderAmbCz.podpis.casoveRazitko",
        "path" : "logHeaderAmbCz.podpis.casoveRazitko",
        "short" : "A.1.9.2 Časové razítko",
        "definition" : "Elektronické časové razítko.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
