# A.4 - Ostatní přílohy - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.4 - Ostatní přílohy**

## Logical Model: A.4 - Ostatní přílohy 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logAttachmentsCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzAttachmentsCz |

 
Ostatní přílohy 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logAttachmentsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAttachmentsCz.csv), [Excel](StructureDefinition-logAttachmentsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAttachmentsCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logAttachmentsCz",
  "version" : "0.1.0",
  "name" : "LogCzAttachmentsCz",
  "title" : "A.4 - Ostatní přílohy",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Ostatní přílohy",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logAttachmentsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAttachmentsCz",
        "path" : "logAttachmentsCz",
        "short" : "A.4 - Ostatní přílohy",
        "definition" : "Ostatní přílohy"
      },
      {
        "id" : "logAttachmentsCz.typObsahu",
        "path" : "logAttachmentsCz.typObsahu",
        "short" : "A.4.1 Typ obsahu",
        "definition" : "Typ obsahu - je  požadován MIME typ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.jazyk",
        "path" : "logAttachmentsCz.jazyk",
        "short" : "A.4.2 Jazyk obsahu",
        "definition" : "Jazyk obsahu - je požadována hodnata z HL7 valueset Languages",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.data",
        "path" : "logAttachmentsCz.data",
        "short" : "A.4.3 Data obsahu",
        "definition" : "Data v base64",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.url",
        "path" : "logAttachmentsCz.url",
        "short" : "A.4.4 URL obsahu",
        "definition" : "Uri kde lze data nalézt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.nazev",
        "path" : "logAttachmentsCz.nazev",
        "short" : "A.4.5 Název obsahu",
        "definition" : "Titulek, který bude zobrazen před daty",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAttachmentsCz.vytvoreni",
        "path" : "logAttachmentsCz.vytvoreni",
        "short" : "A.4.6 Datum vytvoření",
        "definition" : "Datum, kdy byl obsah poprvé vytvořen",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
