# A.2.2 - Urgentní informace - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.2 - Urgentní informace**

## Logical Model: A.2.2 - Urgentní informace 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/logAlertsCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogCzAlertsCz |

 
Urgentní informace 

**Usages:**

* Use this Logical Model: [A - Ambulantní zpráva](StructureDefinition-logOutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/logAlertsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAlertsCz.csv), [Excel](StructureDefinition-logAlertsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAlertsCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/logAlertsCz",
  "version" : "0.1.0",
  "name" : "LogCzAlertsCz",
  "title" : "A.2.2 - Urgentní informace",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Urgentní informace",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/logAlertsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAlertsCz",
        "path" : "logAlertsCz",
        "short" : "A.2.2 - Urgentní informace",
        "definition" : "Urgentní informace"
      },
      {
        "id" : "logAlertsCz.alergie",
        "path" : "logAlertsCz.alergie",
        "short" : "A.2.2.1 - Alergie a intolerance",
        "definition" : "Záznam alergie a intolerance je povinný. U pacientů, bez alergie či intolerance je nutné tento fakt explicitně vyjádřit příslušným kódem.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.popis",
        "path" : "logAlertsCz.alergie.popis",
        "short" : "A.2.2.1.1 - Popis alergie",
        "definition" : "Textové doplnění informací volným textem. Je určeno pro zápis informací, které nelze zapsat strukturovaně.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.puvodce",
        "path" : "logAlertsCz.alergie.puvodce",
        "short" : "A.2.2.1.2 - Původce",
        "definition" : "Látka, skupina látek nebo faktor prostředí, na které je pacient alergický nebo přecitlivělý. Původce je možné vyjádřit pomocí kódu substance, ATC skupiny nebo kódu produktu SÚKL (v případě léčivých přípravků).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.typReakce",
        "path" : "logAlertsCz.alergie.typReakce",
        "short" : "A.2.2.1.3 - Typ reakce",
        "definition" : "Typ (mechanismus) reakce: alergie, intolerance, nealergická hypersenzitivita.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.reakce",
        "path" : "logAlertsCz.alergie.reakce",
        "short" : "A.2.2.1.4 - Reakce",
        "definition" : "Dosud známé projevy reakce na expozici pacienta původci, textem nebo kódem, včetně možnosti uvést způsob expozice a závažnost projevu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.riziko",
        "path" : "logAlertsCz.alergie.riziko",
        "short" : "A.2.2.1.5 - Riziko",
        "definition" : "Stupeň závažnosti je definován jako „potenciální závažnost budoucích reakcí“. Stupeň závažnosti představuje klinické hodnocení nejhoršího scénáře budoucí reakce. Může být založeno na závažnosti minulých reakcí a na stupni ohrožení pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.pocatekProjevu",
        "path" : "logAlertsCz.alergie.pocatekProjevu",
        "short" : "A.2.2.1.6 - Počátek období projevu",
        "definition" : "Datum nebo období, ve kterém byla alergie nebo jiná nežádoucí reakce zaznamenána či klinicky stanovena. Může to být přesné datum a čas nebo hrubý údaj o datu (například pouze rok nebo měsíc a rok) nebo vyjádření pomocí kódu věkové fáze (dětství, adolescence apod.), resp. časového intervalu (2001 - 2005 apod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.pocatekProjevu.datum",
        "path" : "logAlertsCz.alergie.pocatekProjevu.datum",
        "short" : "Počátek období projevu - datum",
        "definition" : "Datum počátku nežádoucí reakce (např. první výskyt).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.pocatekProjevu.kod",
        "path" : "logAlertsCz.alergie.pocatekProjevu.kod",
        "short" : "Počátek období projevu - kód",
        "definition" : "Vyjádření počátku reakce kódem např. věkové skupiny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.konecProjevu",
        "path" : "logAlertsCz.alergie.konecProjevu",
        "short" : "A.2.2.1.7 - Konec období projevu",
        "definition" : "Datum nebo období, ve kterém byly projevy alergie nebo jiné nežádoucí reakce potlačeny nebo klinicky vyloučeny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.konecProjevu.datum",
        "path" : "logAlertsCz.alergie.konecProjevu.datum",
        "short" : "Konec období projevu - datum",
        "definition" : "Konec období projevu - datum",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.konecProjevu.kod",
        "path" : "logAlertsCz.alergie.konecProjevu.kod",
        "short" : "Konec období projevu - kód",
        "definition" : "Konec období projevu - kód",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.stav",
        "path" : "logAlertsCz.alergie.stav",
        "short" : "A.2.2.1.8 - Stav",
        "definition" : "„Klinický stav“ vyjadřuje aktuální stav dispozice pacienta k nežádoucí reakci.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.miraJIstoty",
        "path" : "logAlertsCz.alergie.miraJIstoty",
        "short" : "A.2.2.1.9 - Míra jistoty",
        "definition" : "Umožňuje vyjádřit míru jistoty zapisujícího lékaře ve vztahu k údajům uvedeným v modelu alergie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.alergie.posledniProjev",
        "path" : "logAlertsCz.alergie.posledniProjev",
        "short" : "A.2.2.1.10 - Poslední projev",
        "definition" : "Datum (a čas) poslední známé reakce (projevu).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani",
        "path" : "logAlertsCz.varovani",
        "short" : "A.2.2.2 - Varování",
        "definition" : "Varování relevantní pro danou hospitalizaci (např. vzácná onemocnění, komplikované stavy, přítomnost implantátu apod.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani.oznaceniVarovani",
        "path" : "logAlertsCz.varovani.oznaceniVarovani",
        "short" : "A.2.2.2.1 - Označení varování",
        "definition" : "Název charakterizující typ či předmět varování",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani.kod",
        "path" : "logAlertsCz.varovani.kod",
        "short" : "A.2.2.2.3 - Onemocnění či stav",
        "definition" : "Stav či onemocnění, které je zdrojem/příčinou pro varování.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani.specializovanyLekar",
        "path" : "logAlertsCz.varovani.specializovanyLekar",
        "short" : "A.2.2.2.4 - Specializovaný lékař",
        "definition" : "Kontaktní informace na specialistu, u kterého je pacient v péči - týká se především pacientů se vzácným onemocněním.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani.komentar",
        "path" : "logAlertsCz.varovani.komentar",
        "short" : "A.2.2.2.5 - Komentář",
        "definition" : "Komentář/popis varování volným textem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani.uroven",
        "path" : "logAlertsCz.varovani.uroven",
        "short" : "A.2.2.2.6 - Úroveň",
        "definition" : "Úroveň závažnosti varování",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logAlertsCz.varovani.platnost",
        "path" : "logAlertsCz.varovani.platnost",
        "short" : "A.2.2.2.7 - Období platnosti varování",
        "definition" : "Umožňuje vyjádřit období ve kterém bylo varování aktivní. Týká se přechodných stavů.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
