# Encounter (AMB CZ) - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter (AMB CZ)**

## Resource Profile: Encounter (AMB CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/cz-encounter-amb | *Version*:0.1.0 | |
| * Standards status: *[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_EncounterAmb |

 
This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/cz-encounter-amb)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-encounter-amb.csv), [Excel](StructureDefinition-cz-encounter-amb.xlsx), [Schematron](StructureDefinition-cz-encounter-amb.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-encounter-amb",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/amb/StructureDefinition/encounter-eu-amb"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/cz-encounter-amb",
  "version" : "0.1.0",
  "name" : "CZ_EncounterAmb",
  "title" : "Encounter (AMB CZ)",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "Status of this Hospital stay",
        "definition" : "At the discharge report status of the encounter should be always = \"finished\"",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "definition" : "Concepts representing classification of inpatient encounter such as inpatient, emergency or others due to local variations.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/amb/ValueSet/amb-encounterClass-eu-amb"
        }
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "short" : "Specific type of service."
      },
      {
        "id" : "Encounter.priority",
        "path" : "Encounter.priority",
        "short" : "Encounter priority",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/amb/ValueSet/admission-urgency-eu-amb"
        }
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "The patient present at the encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.basedOn",
        "path" : "Encounter.basedOn",
        "short" : "The request for which this encounter has been made"
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "List of participants involved in the encounters",
        "definition" : "Slice per type of participant: admitter, discharger,.."
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant:admitter",
        "path" : "Encounter.participant",
        "sliceName" : "admitter",
        "short" : "Admitting professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:admitter.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ADM"
            }
          ]
        }
      },
      {
        "id" : "Encounter.participant:discharger",
        "path" : "Encounter.participant",
        "sliceName" : "discharger",
        "short" : "Discharging professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:discharger.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "DIS"
            }
          ]
        }
      },
      {
        "id" : "Encounter.participant:referrer",
        "path" : "Encounter.participant",
        "sliceName" : "referrer",
        "short" : "Referring professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:referrer.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "REF"
            }
          ]
        }
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "short" : "The start and end time of this encounter.",
        "definition" : "The start and end time of this inpatient stay.",
        "min" : 1
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "short" : "The list of diagnosis relevant to this encounter, see comment",
        "comment" : "While Encounter.diagnosis could be optionally populated, mainly for administrative purposes, we strongly recommend to put all clinical relevant diagnoses, stated at start, during and at the end of the hospital stay, into the corresponding section(s) of the HDR."
      },
      {
        "id" : "Encounter.location",
        "path" : "Encounter.location",
        "short" : "Locations where the patient stayed"
      },
      {
        "id" : "Encounter.location.location",
        "path" : "Encounter.location.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.location.period",
        "path" : "Encounter.location.period",
        "short" : "Location period"
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
