# A.2.8 - Medication Summary - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.8 - Medication Summary**

## Logical Model: A.2.8 - Medication Summary 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogEnMedicationSummaryCz |

 
Medication Summary 

**Usages:**

* Use this Logical Model: [A - Outpatient Encounter Report](StructureDefinition-OutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/MedicationSummaryCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationSummaryCz.csv), [Excel](StructureDefinition-MedicationSummaryCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationSummaryCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz",
  "version" : "0.1.0",
  "name" : "LogEnMedicationSummaryCz",
  "title" : "A.2.8 - Medication Summary",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Medication Summary",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/MedicationSummaryCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationSummaryCz",
        "path" : "MedicationSummaryCz",
        "short" : "A.2.8 - Medication Summary",
        "definition" : "Medication Summary"
      },
      {
        "id" : "MedicationSummaryCz.status",
        "path" : "MedicationSummaryCz.status",
        "short" : "A.2.9.2.1 Stav",
        "definition" : "Stav identifikuje změny v medikaci v průběhu ambulantního kontaktu. Položka je důležitá pro rozlišení medikace ukončené, změněné či nově podávané v průběhu ambulantního kontaktu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.reason",
        "path" : "MedicationSummaryCz.reason",
        "short" : "A.2.9.2.2 Indikace",
        "definition" : "Důvod medikace. Důvod může být popsán textem případně odkazem na zdravotní důvod (zdravotní problém v seznamu problémů).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.changeReason",
        "path" : "MedicationSummaryCz.changeReason",
        "short" : "A.2.9.2.3 Důvod změny medikace",
        "definition" : "Důvod změny medikace vyjádřený textem případně kódem (např. nevhodné/nedostatečné dávkování, interakce léků a pod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.productCode",
        "path" : "MedicationSummaryCz.productCode",
        "short" : "A.2.9.2.4 Kód SUKL",
        "definition" : "Kód léčiva dle databáze SÚKL.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.productName",
        "path" : "MedicationSummaryCz.productName",
        "short" : "A.2.9.2.5 Název léčivého přípravku",
        "definition" : "Registrovaný název léčiva dle databáze léčivých přípravků, nebo IPS Absent and Unknown.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.activeIngredients",
        "path" : "MedicationSummaryCz.activeIngredients",
        "short" : "A.2.9.2.6 Aktivní látky",
        "definition" : "Seznam aktivních látek v léčivu odvozený od záznamu HVLP nebo IVLP přípravku v databázi SUKL (DLP). Aktivní látky jsou uváděny názvem a případně také kódem ATC či IDMP dle registru substancí SRS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.strength",
        "path" : "MedicationSummaryCz.strength",
        "short" : "A.2.9.2.7 Síla",
        "definition" : "Síla aktivní léčivé látky obsažené v léčivém přípravku. Síla se vyjadřuje ve vztahu k jednotce podání. Např. 500mg v tabletě.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.dosageForm",
        "path" : "MedicationSummaryCz.dosageForm",
        "short" : "A.2.9.2.8 Forma léčiva",
        "definition" : "Léková forma obsažená v balení vyjádřená kódem. Např. sirup, tableta apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.dosingInstructions",
        "path" : "MedicationSummaryCz.dosingInstructions",
        "short" : "A.2.9.2.9 Dávkování",
        "definition" : "Frekvence a počet jednotek podání volným textem nebo formalizovaně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.route",
        "path" : "MedicationSummaryCz.route",
        "short" : "A.2.9.2.10 Cesta podání",
        "definition" : "Cesta podání.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.period",
        "path" : "MedicationSummaryCz.period",
        "short" : "A.2.9.2.11 Období podávání",
        "definition" : "Časový interval kdy pacientovi byla, případně nebyla medikace podávána.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "MedicationSummaryCz.duration",
        "path" : "MedicationSummaryCz.duration",
        "short" : "A.2.9.2.12 Délka vybavení",
        "definition" : "Počet dnů na který byl pacient vybaven léčivem. Pokud pacient nebyl vybaven, lékař zaznamená hodnotu 0.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
