# A.2.3 - Encounter - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.3 - Encounter**

## Logical Model: A.2.3 - Encounter 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/StructureDefinition/EncounterCz | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:LogEnEncounterCz |

 
Encounter 

**Usages:**

* Use this Logical Model: [A - Outpatient Encounter Report](StructureDefinition-OutpatientEncounterReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.amb|current/StructureDefinition/EncounterCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-EncounterCz.csv), [Excel](StructureDefinition-EncounterCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EncounterCz",
  "url" : "https://hl7.cz/fhir/amb/StructureDefinition/EncounterCz",
  "version" : "0.1.0",
  "name" : "LogEnEncounterCz",
  "title" : "A.2.3 - Encounter",
  "status" : "draft",
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Encounter",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/amb/StructureDefinition/EncounterCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "EncounterCz",
        "path" : "EncounterCz",
        "short" : "A.2.3 - Encounter",
        "definition" : "Encounter"
      },
      {
        "id" : "EncounterCz.type",
        "path" : "EncounterCz.type",
        "short" : "A.2.3.1 - Encounter type",
        "definition" : "The type of the encounter whether inpatient or short stay encounter.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EncounterCz.note",
        "path" : "EncounterCz.note",
        "short" : "A.2.3.2 - Encounter note",
        "definition" : "A narrative description of the encounter course.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission",
        "path" : "EncounterCz.admission",
        "short" : "A.2.3.3 - Admission",
        "definition" : "Admission",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.urgency",
        "path" : "EncounterCz.admission.urgency",
        "short" : "A.2.3.3.1 - Admission urgency",
        "definition" : "Admission type, either emergency or planned",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.date",
        "path" : "EncounterCz.admission.date",
        "short" : "A.2.3.3.2 - Admission date",
        "definition" : "Admission date and time.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.admitter",
        "path" : "EncounterCz.admission.admitter",
        "short" : "Admitting professional",
        "definition" : "Admitting Healthcare Professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.admitter.identifier",
        "path" : "EncounterCz.admission.admitter.identifier",
        "short" : "A.2.3.3.3 - Admitting professional ID",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.admitter.name",
        "path" : "EncounterCz.admission.admitter.name",
        "short" : "A.2.3.3.4 - Admitting professional name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.admitter.organizationID",
        "path" : "EncounterCz.admission.admitter.organizationID",
        "short" : "A.2.3.3.5 - Admitting organisation ID",
        "definition" : "The healthcare provider organisation identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.admitter.organization",
        "path" : "EncounterCz.admission.admitter.organization",
        "short" : "A.2.3.3.6 - Admitting organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.source",
        "path" : "EncounterCz.admission.source",
        "short" : "A.2.3.3.7 - Admit Source",
        "definition" : "From where the patient was admitted (e.g. physician referral, transfer).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.referringHP",
        "path" : "EncounterCz.admission.referringHP",
        "short" : "Referring professional",
        "definition" : "Referring Healthcare Professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.referringHP.identifier",
        "path" : "EncounterCz.admission.referringHP.identifier",
        "short" : "A.2.3.3.8 - Referring professional ID",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.referringHP.name",
        "path" : "EncounterCz.admission.referringHP.name",
        "short" : "A.2.3.3.9 - Referring professional name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.referringHP.organizationID",
        "path" : "EncounterCz.admission.referringHP.organizationID",
        "short" : "A.2.3.3.10 - Referring organisation ID",
        "definition" : "The healthcare provider organisation identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "EncounterCz.admission.referringHP.organization",
        "path" : "EncounterCz.admission.referringHP.organization",
        "short" : "A.2.3.3.11 - Referring organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.admissionReason",
        "path" : "EncounterCz.admissionReason",
        "short" : "A.2.3.4 - Admission reason",
        "definition" : "Admission reason",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.admissionReason.code",
        "path" : "EncounterCz.admissionReason.code",
        "short" : "A.2.3.4.1 - Admission reason",
        "definition" : "Reason or reasons for admission, e.g. Problem, procedure or finding.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EncounterCz.admissionReason.comment",
        "path" : "EncounterCz.admissionReason.comment",
        "short" : "A.2.3.4.2 - Admission reason comment",
        "definition" : "Explanation of the reason for the encounter.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "EncounterCz.admissionReason.legalStatus",
        "path" : "EncounterCz.admissionReason.legalStatus",
        "short" : "A.2.3.4.3 - Admission legal status",
        "definition" : "Legal status/situation at admission. The legal status indicates the basis on which the patient is staying in a healthcare organisation. This can be either voluntary or involuntary, however the legal status is always determined by a court. A patient can also receive healthcare based on a forensic status. (voluntary, involuntary, admission by legal authority).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "EncounterCz.location",
        "path" : "EncounterCz.location",
        "short" : "A.2.3.6 - Location - Identifikacition of outpatient place of healthcare service provision",
        "definition" : "A.2.3.6 - Location - Identifikacition of outpatient place of healthcare service provision",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.location.period",
        "path" : "EncounterCz.location.period",
        "short" : "A.2.3.6.1 - Period",
        "definition" : "Time period during which the patient was present at the location",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "EncounterCz.location.organization",
        "path" : "EncounterCz.location.organization",
        "short" : "Organization",
        "definition" : "Organization or organization part where the patient was present.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "EncounterCz.location.organization.identifier",
        "path" : "EncounterCz.location.organization.identifier",
        "short" : "A.2.3.6.2 - Organisation Part ID",
        "definition" : "The organisation’s part identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "EncounterCz.location.organization.name",
        "path" : "EncounterCz.location.organization.name",
        "short" : "A.2.3.6.3 - Organisation Part Name",
        "definition" : "Full name of the organisation part, e.g. Name of the department",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "EncounterCz.location.organization.details",
        "path" : "EncounterCz.location.organization.details",
        "short" : "A.2.3.6.4 - Organisation Part Details",
        "definition" : "Address, contact names and contact details, specialty of the organisation part.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
