# Practitioner-123456789 - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner-123456789**

## Example Practitioner: Practitioner-123456789

Profile: [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/krzp`/123456789

**name**: Lékař Antonín 

**telecom**: [+420 212 345 678](tel:+420212345678)

**address**: Nová ulice 25, 130 00, Praha 3(work)

**gender**: Male

**birthDate**: 1967-07-10

**communication**: Czech



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "161dcf7e-928b-437a-a310-6c61038e6ff9",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
      "value" : "123456789"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Antonín",
      "given" : ["Lékař"],
      "prefix" : ["MUDr."],
      "suffix" : ["PhD."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 212 345 678",
      "use" : "home"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "both",
      "text" : "Nová ulice 25, 130 00, Praha 3",
      "line" : ["Nová ulice 25", null],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Nová ulice"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "25"
            }
          ]
        }
      ],
      "city" : "Praha 3",
      "postalCode" : "13000",
      "country" : "CZ"
    }
  ],
  "gender" : "male",
  "birthDate" : "1967-07-10",
  "communication" : [
    {
      "coding" : [
        {
          "system" : "urn:ietf:bcp:47",
          "code" : "cs"
        }
      ]
    }
  ]
}

```
