# CZ Attachement Model to this guide Map - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Attachement Model to this guide Map**

## ConceptMap: CZ Attachement Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/amb/ConceptMap/attachement2FHIR-cz-amb | *Version*:0.1.0 |
| Draft as of 2026-01-30 | *Computable Name*:Attachement2FHIRCzAmb |

 
AMB Attachement Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "attachement2FHIR-cz-amb",
  "url" : "https://hl7.cz/fhir/amb/ConceptMap/attachement2FHIR-cz-amb",
  "version" : "0.1.0",
  "name" : "Attachement2FHIRCzAmb",
  "title" : "CZ Attachement Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-30T21:34:26+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "AMB Attachement Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
      "element" : [
        {
          "code" : "Attachments",
          "display" : "A.4 - Attachments",
          "target" : [
            {
              "code" : "Composition.section:sectionAttachments.entry[x].DocumentReference.content[x].attachment",
              "display" : "If it is additional attachments",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-attachment-hdr",
      "element" : [
        {
          "code" : "Attachments.contentType",
          "display" : "A.4.1 - Content type of media attachments",
          "target" : [
            {
              "code" : "content[x].attachment.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.language",
          "display" : "A.4.2 - Language of media attachments",
          "target" : [
            {
              "code" : "content[x].attachment.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.data",
          "display" : "A.4.3 - Data of media attachments",
          "target" : [
            {
              "code" : "content[x].attachment.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.url",
          "display" : "A.4.4 - URL of media attachments",
          "target" : [
            {
              "code" : "content[x].attachment.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.title",
          "display" : "A.4.5 - Title of media attachments",
          "target" : [
            {
              "code" : "content[x].attachment.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.creation",
          "display" : "A.4.6 - Date and time of creation",
          "target" : [
            {
              "code" : "content[x].attachment.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
