# OutpatientBundle-Mracena - HL7 Czech Outpatient Encounter Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **OutpatientBundle-Mracena**

## Example Bundle: OutpatientBundle-Mracena



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "OutpatientBundle-Mracena",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/amb/StructureDefinition/cz-bundle-amb"]
  },
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:cc5b2f9b-dc18-40b3-a67a-ff1700c52405"
  },
  "type" : "document",
  "timestamp" : "2026-01-29T17:50:08+01:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:698056a8-57a6-49ed-909e-ea4216b18a6d",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "698056a8-57a6-49ed-909e-ea4216b18a6d",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/amb/StructureDefinition/cz-composition-amb"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_698056a8-57a6-49ed-909e-ea4216b18a6d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition 698056a8-57a6-49ed-909e-ea4216b18a6d</b></p><a name=\"698056a8-57a6-49ed-909e-ea4216b18a6d\"> </a><a name=\"hc698056a8-57a6-49ed-909e-ea4216b18a6d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-composition-amb.html\">Composition: Outpatient Encounter Report (CZ)</a></p></div><p><b>Composition: Presented Form</b>: </p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 34108-1}\">Outpatient Note</span></p><p><b>date</b>: 2026-01-29 17:50:08+0100</p><p><b>author</b>: <a href=\"Bundle-OutpatientBundle-Mracena.html#urn-uuid-161dcf7e-928b-437a-a310-6c61038e6ff9\">Practitioner Lékař Antonín </a></p><p><b>title</b>: Ambulantní zpráva</p></div>"
        },
        "extension" : [
          {
            "url" : "https://hl7.cz/fhir/core/StructureDefinition/presentedForm",
            "valueAttachment" : {
              "contentType" : "application/pdf",
              "language" : "cs",
              "title" : "Ambulantní zpráva",
              "creation" : "2026-01-29T17:50:08+01:00"
            }
          }
        ],
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34108-1",
              "display" : "Outpatient Note"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:00d304b8-5839-43dd-9239-69aed544f7e1"
        },
        "date" : "2026-01-29T17:50:08+01:00",
        "author" : [
          {
            "reference" : "urn:uuid:161dcf7e-928b-437a-a310-6c61038e6ff9"
          }
        ],
        "title" : "Ambulantní zpráva"
      }
    },
    {
      "fullUrl" : "urn:uuid:00d304b8-5839-43dd-9239-69aed544f7e1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "00d304b8-5839-43dd-9239-69aed544f7e1",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_00d304b8-5839-43dd-9239-69aed544f7e1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 00d304b8-5839-43dd-9239-69aed544f7e1</b></p><a name=\"00d304b8-5839-43dd-9239-69aed544f7e1\"> </a><a name=\"hc00d304b8-5839-43dd-9239-69aed544f7e1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html\">Patient (CZ core)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Mračena Mrakomorová  (no stated gender), DoB: 1971-11-26 ( Passport number (use: official, ))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Ids (see the one above)\">Other Ids:</td><td colspan=\"3\"><ul><li><code>https://ncez.mzcr.cz/fhir/sid/rcis</code>/7161264528 (use: official, )</li><li><code>https://ncez.mzcr.cz/fhir/sid/rid</code>/2066425387</li><li>Passport number/23476533 (use: official, )</li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
            "value" : "7161264528"
          },
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
            "value" : "2066425387"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PPN"
                }
              ]
            },
            "system" : "http://terminology.hl7.org/NamingSystem/passportNumNS-CZE",
            "value" : "23476533",
            "assigner" : {
              "display" : "Ministerstvo vnitra České republiky"
            }
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PPN"
                }
              ]
            },
            "system" : "http://terminology.hl7.org/NamingSystem/passportNumNS-SVK",
            "value" : "88476522"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Mrakomorová",
            "given" : ["Mračena"]
          }
        ],
        "birthDate" : "1971-11-26"
      }
    },
    {
      "fullUrl" : "urn:uuid:161dcf7e-928b-437a-a310-6c61038e6ff9",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "161dcf7e-928b-437a-a310-6c61038e6ff9",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_161dcf7e-928b-437a-a310-6c61038e6ff9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 161dcf7e-928b-437a-a310-6c61038e6ff9</b></p><a name=\"161dcf7e-928b-437a-a310-6c61038e6ff9\"> </a><a name=\"hc161dcf7e-928b-437a-a310-6c61038e6ff9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html\">Practitioner (CZ core)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/krzp</code>/123456789</p><p><b>name</b>: Lékař Antonín </p><p><b>telecom</b>: <a href=\"tel:+420212345678\">+420 212 345 678</a></p><p><b>address</b>: Nová ulice 25, 130 00, Praha 3(work)</p><p><b>gender</b>: Male</p><p><b>birthDate</b>: 1967-07-10</p><p><b>communication</b>: <span title=\"Codes:{urn:ietf:bcp:47 cs}\">Czech</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
            "value" : "123456789"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Antonín",
            "given" : ["Lékař"],
            "prefix" : ["MUDr."],
            "suffix" : ["PhD."]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+420 212 345 678",
            "use" : "home"
          }
        ],
        "address" : [
          {
            "use" : "work",
            "type" : "both",
            "text" : "Nová ulice 25, 130 00, Praha 3",
            "line" : ["Nová ulice 25", null],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Nová ulice"
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "25"
                  }
                ]
              }
            ],
            "city" : "Praha 3",
            "postalCode" : "13000",
            "country" : "CZ"
          }
        ],
        "gender" : "male",
        "birthDate" : "1967-07-10",
        "communication" : [
          {
            "coding" : [
              {
                "system" : "urn:ietf:bcp:47",
                "code" : "cs"
              }
            ]
          }
        ]
      }
    }
  ]
}

```
