# hl7.fhir.cz.hie#0.0.1: HL7 Czech Health information exchange Implementation Guide

## Pages

* [Home](index.md)
* [RESTful ATNA (ATNA)](atna-cs.md)
* [Provide document bundle [ITI-65]](iti-65.md)
* [Profiles](profiles.md)
* [Dependencies](dependencies.md)
* [Find Document Lists [ITI-66]](iti-66-cs.md)
* [Find Document References [ITI-67]](iti-67.md)
* [Authors](authors.md)
* [RESTful ATNA (ATNA)](atna.md)
* [Downloads](downloads.md)
* [CZ:ATC Audit Event Content Profiles (ATNA)](volume3.md)
* [Record Audit Event [ITI-20]](iti-20-cs.md)
* [Find Document Lists [ITI-66]](iti-66.md)
* [Mobile Access to Health Documents (MHD)](mhd.md)
* [Artifacts](artifacts.md)
* [Copyright](copyright.md)
* [Retrieve ATNA Audit Event [ITI-81]](iti-81-cs.md)
* [Mobile Access to Health Documents (MHD)](mhd-cs.md)
* [Record Audit Event [ITI-20]](iti-20.md)
* [Závislosti](dependencies-cs.md)
* [Ke stažení](downloads-cs.md)
* [Autoři](authors-cs.md)
* [Retrieve Document [ITI-68]](iti-68.md)
* [Provide document bundle [ITI-65]](iti-65-cs.md)
* [Find Document References [ITI-67]](iti-67-cs.md)
* [Autorská práva](copyright-cs.md)
* [Retrieve ATNA Audit Event [ITI-81]](iti-81.md)
* [CZ:ATC Audit Event Content Profiles (ATNA)](volume3-cs.md)
* [Retrieve Document [ITI-68]](iti-68-cs.md)

## Resources

### CodeSystems

* [CZ HPD Audit Event Type CodeSystem](CodeSystem-cz-HPDAuditEvent-type-cs.md)
* [CZ Policy Audit Event Type CodeSystem](CodeSystem-cz-PolicyAuditEvent-type-cs.md)
* [CZ Audit Trail Consumption Event Types CodeSystem](CodeSystem-cz-atc-cs.md)
* [CZ Document Audit Event Type CodeSystem](CodeSystem-cz-documentAuditEvent-type-cs.md)
* [CZ DocumentEntry AuthorRole CodeSystem](CodeSystem-cz-documentEntry-authorRole-cs.md)
* [CZ DocumentEntry TypeCode CodeSystem](CodeSystem-cz-documentEntry-typeCode-cs.md)
* [CZ Participants CodeSystem](CodeSystem-cz-participants-cs.md)
* [CZ Purpose of use CodeSystem](CodeSystem-cz-purposeOfUse-cs.md)

### ValueSets

* [CZ HPD Audit Event Type ValueSet](ValueSet-cz-HPDAuditEvent-type-vs.md)
* [CZ Policy Audit Event Type ValueSet](ValueSet-cz-PolicyAuditEvent-type-vs.md)
* [CZ Document Audit Event Type ValueSet](ValueSet-cz-documentAuditEvent-type-vs.md)
* [CZ DocumentEntry AuthorRole ValueSet](ValueSet-cz-documentEntry-authorRole-vs.md)
* [CZ DocumentEntry ClassCode ValueSet](ValueSet-cz-documentEntry-classCode-vs.md)
* [CZ DocumentEntry Confidentiality ValueSet](ValueSet-cz-documentEntry-confidentialityCode-vs.md)
* [CZ DocumentEntry TypeCode ValueSet](ValueSet-cz-documentEntry-typeCode-vs.md)
* [CZ Participants ValueSet](ValueSet-cz-participants-vs.md)
* [CZ Purpose of use ValueSet](ValueSet-cz-purposeOfUse-vs.md)

### Complex-type Profiles

* [CZ Unique ID Identifier](StructureDefinition-cz-uniqueIDIdentifier.md)

### Resource Profiles

* [CZ Audit Event](StructureDefinition-cz-auditEvent.md)
* [CZ Audit Event for [ITI-65] Document Recipient](StructureDefinition-cz-auditEventIti65Recipient.md)
* [CZ Audit Event for [ITI-65] Document Source](StructureDefinition-cz-auditEventIti65Source.md)
* [CZ Audit Event for [ITI-66] Document List Consumer](StructureDefinition-cz-auditEventIti66Consumer.md)
* [CZ Audit Event for [ITI-66] Document List](StructureDefinition-cz-auditEventIti66Responder.md)
* [CZ Audit Event for [ITI-67] Document Consumer](StructureDefinition-cz-auditEventIti67Consumer.md)
* [CZ Audit Event for [ITI-67] Document Responder](StructureDefinition-cz-auditEventIti67Responder.md)
* [CZ Audit Event for [ITI-68] Document Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)
* [CZ Audit Event for [ITI-68] Document Responder](StructureDefinition-cz-auditEventIti68Responder.md)
* [CZ Document Audit Event](StructureDefinition-cz-documentAuditEvent.md)
* [CZ HPD Audit Event](StructureDefinition-cz-hpdAuditEvent.md)
* [CZ MHD DocumentReference Comprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md)
* [CZ MHD Find Document Lists Comprehensive Response Message](StructureDefinition-cz-mhd-finddocumentlists-comprehensive-bundle.md)
* [CZ MHD Find Document References Comprehensive Response message](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.md)
* [CZ MHD Folder Comprehensive](StructureDefinition-cz-mhd-folder-comprehensive.md)
* [CZ MHD Provide Document Bundle Comprehensive Response](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive-response.md)
* [CZ MHD Provide Document Bundle Comprehensive](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.md)
* [CZ MHD SubmissionSet Comprehensive](StructureDefinition-cz-mhd-submissionset-comprehensive.md)
* [CZ Policy Audit Event](StructureDefinition-cz-policyAuditEvent.md)

### CapabilityStatements

* [ATNA Audit Creator (client)](CapabilityStatement-CZ-ATNA-AuditCreator.md)
* [ATNA Audit Record Repository (server)](CapabilityStatement-CZ-ATNA-AuditRecordRepository.md)
* [MHD Document Consumer (client)](CapabilityStatement-CZ-MHD-DocumentConsumer.md)
* [MHD Document Recipient (server)](CapabilityStatement-CZ-MHD-DocumentRecipient.md)
* [MHD Document Responder (server)](CapabilityStatement-CZ-MHD-DocumentResponder.md)
* [MHD Document Source (client)](CapabilityStatement-CZ-MHD-DocumentSource.md)

### ImplementationGuides

* [HL7 Czech Health information exchange Implementation Guide](index.md)

### Examples

* [CZ-AuditEventIti65RecipientExample (AuditEvent)](AuditEvent-CZ-AuditEventIti65RecipientExample.md)
* [CZ-AuditEventIti65SourceExample (AuditEvent)](AuditEvent-CZ-AuditEventIti65SourceExample.md)
* [CZ-AuditEventIti66ConsumerExample (AuditEvent)](AuditEvent-CZ-AuditEventIti66ConsumerExample.md)
* [CZ-AuditEventIti66ResponderExample (AuditEvent)](AuditEvent-CZ-AuditEventIti66ResponderExample.md)
* [CZ-AuditEventIti67ConsumerExample (AuditEvent)](AuditEvent-CZ-AuditEventIti67ConsumerExample.md)
* [CZ-AuditEventIti67ResponderExample (AuditEvent)](AuditEvent-CZ-AuditEventIti67ResponderExample.md)
* [CZ-AuditEventIti68ConsumerExample (AuditEvent)](AuditEvent-CZ-AuditEventIti68ConsumerExample.md)
* [CZ-AuditEventIti68ResponderExample (AuditEvent)](AuditEvent-CZ-AuditEventIti68ResponderExample.md)
