# Home - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/ImplementationGuide/hl7.fhir.cz.hie | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:HL7CzHIEImplementationGuide |

### Introduction

This implementation specification focuses on the national implementation of the MHD (Mobile access to Health Documents) profile and Restful ATNA within the environment of Accredited Affinity Domains (AAfD) and the central eHealth services (EZ), based on the national [Standard of Accredited Affinity Domains](https://ncez.mzcr.cz/sites/default/files/media-documents/Standard%20Do%C4%8Dasn%C3%A9%20ulo%C5%BEi%C5%A1t%C4%9B%20v%200.10.pdf).

### Scope

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* Volume 1: 
* [Mobile Access to Health Documents (MHD)](mhd.md): This section specifies Czech national extensions to the Mobile Access to Health Documents (MHD)
* [Restful ATNA (ATNA)](atna.md): This section specifies Czech national extensions to the Restful ATNA (ATNA)
 
* Volume 2: 
* [Record Audit Event [ITI-20]](iti-20.md): This section describes the additional requirements for the Czech HIE of the Record Audit Event [ITI-20] transaction defined in the Add RESTful ATNA (Query and Feed) supplement published in the IHE ITI Trial Implementation.
* [Provide Document Bundle [ITI-65]](iti-65.md): This section describes the additional requirements for the Czech HIE of the Provide Document Bundle [ITI-65] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Find Document Lists [ITI-66]](iti-66.md): This section describes the additional requirements for the Czech HIE of the Find Document Lists [ITI-66] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Find Document References [ITI-67]](iti-67.md): This section describes the additional requirements for the Czech HIE of the Find Document References [ITI-67] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Retrieve Document [ITI-68]](iti-68.md): This section describes the additional requirements for the Czech HIE of the Retrieve Document [ITI-68] transaction defined in the MHD Profile published in the IHE ITI Trial Implementation “Mobile Access to Health Documents”.
* [Retrieve ATNA Audit Event [ITI-81]](iti-81.md): This section describes the additional requirements for the Czech HIE of the Retrieve ATNA Audit Event [ITI-81] transaction defined in the Add RESTful ATNA (Query and Feed) supplement published in the IHE ITI Trial Implementation.
 
* [Volume 3](volume3.md): This page describes implementation of ATC Audit Event Content Profiles.
* Appendix: 
* [Profiles](profiles.md): This section contains all profiles defined in this implementation guide.
 
* About: 
* [Authors](authors.md): This segment contains informaction about authors.
* [Downloads](downloads.md): This segment contains informaction about downloads.
* [Dependencies](dependencies.md): This segment contains informaction about dependencies.
* [Copyright](copyright.md): This segment contains informaction about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Dependencies











### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.hie.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.hie.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CZ_ATCCs](CodeSystem-cz-atc-cs.md), [CZ_ATNA_Audit_Creator](CapabilityStatement-CZ-ATNA-AuditCreator.md)...Show 42 more,[CZ_ATNA_Audit_Record_Repository](CapabilityStatement-CZ-ATNA-AuditRecordRepository.md),[CZ_AuditEvent](StructureDefinition-cz-auditEvent.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md),[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md),[CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md),[CZ_DocumentAuditEventTypeCs](CodeSystem-cz-documentAuditEvent-type-cs.md),[CZ_DocumentAuditEventTypeVs](ValueSet-cz-documentAuditEvent-type-vs.md),[CZ_DocumentEntryAuthorRoleCs](CodeSystem-cz-documentEntry-authorRole-cs.md),[CZ_DocumentEntryAuthorRoleVs](ValueSet-cz-documentEntry-authorRole-vs.md),[CZ_DocumentEntryClassCodeVs](ValueSet-cz-documentEntry-classCode-vs.md),[CZ_DocumentEntryConfidentialityCodeVs](ValueSet-cz-documentEntry-confidentialityCode-vs.md),[CZ_DocumentEntryTypeCodeCs](CodeSystem-cz-documentEntry-typeCode-cs.md),[CZ_DocumentEntryTypeCodeVs](ValueSet-cz-documentEntry-typeCode-vs.md),[CZ_FindDocumentReferencesComprehensiveResponse](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.md),[CZ_FindListsComprehensiveResponse](StructureDefinition-cz-mhd-finddocumentlists-comprehensive-bundle.md),[CZ_Folder](StructureDefinition-cz-mhd-folder-comprehensive.md),[CZ_HIEPurposeOfUseCs](CodeSystem-cz-purposeOfUse-cs.md),[CZ_HIEPurposeOfUseVs](ValueSet-cz-purposeOfUse-vs.md),[CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md),[CZ_HPDAuditEventTypeCs](CodeSystem-cz-HPDAuditEvent-type-cs.md),[CZ_HPDAuditEventTypeVs](ValueSet-cz-HPDAuditEvent-type-vs.md),[CZ_MHD_DocumentConsumer](CapabilityStatement-CZ-MHD-DocumentConsumer.md),[CZ_MHD_DocumentRecipient](CapabilityStatement-CZ-MHD-DocumentRecipient.md),[CZ_MHD_DocumentResponder](CapabilityStatement-CZ-MHD-DocumentResponder.md),[CZ_MHD_DocumentSource](CapabilityStatement-CZ-MHD-DocumentSource.md),[CZ_MhdDocumentReferenceComprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md),[CZ_MhdProvideDocumentBundleComprehensive](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.md),[CZ_MhdProvideDocumentBundleComprehensiveResponse](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive-response.md),[CZ_MhdSubmissionSetComprehensive](StructureDefinition-cz-mhd-submissionset-comprehensive.md),[CZ_ParticipantsCs](CodeSystem-cz-participants-cs.md),[CZ_ParticipantsVs](ValueSet-cz-participants-vs.md),[CZ_PolicyAuditEventTypeCs](CodeSystem-cz-PolicyAuditEvent-type-cs.md),[CZ_PolicyAuditEventTypeVs](ValueSet-cz-PolicyAuditEvent-type-vs.md),[CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md),[CZ_UniqueIDIdentifier](StructureDefinition-cz-uniqueIDIdentifier.md)and[HL7CzHIEImplementationGuide](index.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [Audit Event ID](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-type.html): [AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md), [AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md)...Show 13 more,[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md),[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md),[CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md),[CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md)and[CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* DICOM Controlled Terminology Definitions: [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 17 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md),[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md),[CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md),[CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md)and[CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md)


* These codes are excerpted from ISO Standard, TS 21089-2017 - Health Informatics - Trusted End-to-End Information Flows, Copyright by ISO International. Copies of this standard are available through the ISO Web Site at www.iso.org.

* [ISO 21089 2017 Health Record Lifecycle Events](http://terminology.hl7.org/6.5.0/CodeSystem-iso-21089-lifecycle.html): [CZ_DocumentAuditEvent](StructureDefinition-cz-documentAuditEvent.md), [CZ_HPDAuditEvent](StructureDefinition-cz-hpdAuditEvent.md) and [CZ_PolicytAuditevent](StructureDefinition-cz-policyAuditEvent.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md), [CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md), [CZ_DocumentEntryClassCodeVs](ValueSet-cz-documentEntry-classCode-vs.md), [CZ_DocumentEntryConfidentialityCodeVs](ValueSet-cz-documentEntry-confidentialityCode-vs.md) and [CZ_MhdDocumentReferenceComprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Audit event entity type](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html): [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 14 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)and[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md)
* [AuditEventEntityRole](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html): [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 14 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)and[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [CZ_MhdDocumentReferenceComprehensive](StructureDefinition-cz-mhd-documentreference-comprehensive.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [AuditEvent/CZ-AuditEventIti65RecipientExample](AuditEvent-CZ-AuditEventIti65RecipientExample.md), [AuditEvent/CZ-AuditEventIti65SourceExample](AuditEvent-CZ-AuditEventIti65SourceExample.md)...Show 14 more,[AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md),[AuditEvent/CZ-AuditEventIti66ResponderExample](AuditEvent-CZ-AuditEventIti66ResponderExample.md),[AuditEvent/CZ-AuditEventIti67ConsumerExample](AuditEvent-CZ-AuditEventIti67ConsumerExample.md),[AuditEvent/CZ-AuditEventIti67ResponderExample](AuditEvent-CZ-AuditEventIti67ResponderExample.md),[AuditEvent/CZ-AuditEventIti68ConsumerExample](AuditEvent-CZ-AuditEventIti68ConsumerExample.md),[AuditEvent/CZ-AuditEventIti68ResponderExample](AuditEvent-CZ-AuditEventIti68ResponderExample.md),[CZ_AuditEventIti65Recipient](StructureDefinition-cz-auditEventIti65Recipient.md),[CZ_AuditEventIti65Source](StructureDefinition-cz-auditEventIti65Source.md),[CZ_AuditEventIti66Consumer](StructureDefinition-cz-auditEventIti66Consumer.md),[CZ_AuditEventIti66Responder](StructureDefinition-cz-auditEventIti66Responder.md),[CZ_AuditEventIti67Consumer](StructureDefinition-cz-auditEventIti67Consumer.md),[CZ_AuditEventIti67Responder](StructureDefinition-cz-auditEventIti67Responder.md),[CZ_AuditEventIti68Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)and[CZ_AuditEventIti68Responder](StructureDefinition-cz-auditEventIti68Responder.md)


