# CZ DocumentEntry Confidentiality ValueSet - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DocumentEntry Confidentiality ValueSet**

## ValueSet: CZ DocumentEntry Confidentiality ValueSet 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-confidentialityCode-vs | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_DocumentEntryConfidentialityCodeVs |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Document confidentiality codes. 

 **References** 

* [CZ Audit Event for [ITI-68] Document Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)
* [CZ Audit Event for [ITI-68] Document Responder](StructureDefinition-cz-auditEventIti68Responder.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 2 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-documentEntry-confidentialityCode-vs",
  "url" : "https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-confidentialityCode-vs",
  "version" : "0.0.1",
  "name" : "CZ_DocumentEntryConfidentialityCodeVs",
  "title" : "CZ DocumentEntry Confidentiality ValueSet",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Document confidentiality codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "17621005",
            "display" : "Normal"
          },
          {
            "code" : "263856008",
            "display" : "Restricted"
          }
        ]
      }
    ]
  }
}

```
