# CZ Policy Audit Event - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Policy Audit Event**

## Resource Profile: CZ Policy Audit Event 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-policyAuditEvent | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_PolicytAuditevent |

 
CZ FHIR profile on AuditEvent for policy. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-policyAuditEvent)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-policyAuditEvent.csv), [Excel](StructureDefinition-cz-policyAuditEvent.xlsx), [Schematron](StructureDefinition-cz-policyAuditEvent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-policyAuditEvent",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-policyAuditEvent",
  "version" : "0.0.1",
  "name" : "CZ_PolicytAuditevent",
  "title" : "CZ Policy Audit Event",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ FHIR profile on AuditEvent for policy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "fhirprovenance",
      "uri" : "http://hl7.org/fhir/provenance",
      "name" : "FHIR Provenance Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AuditEvent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AuditEvent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AuditEvent",
        "path" : "AuditEvent"
      },
      {
        "id" : "AuditEvent.type",
        "path" : "AuditEvent.type",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/audit-event-type"
        }
      },
      {
        "id" : "AuditEvent.subtype",
        "path" : "AuditEvent.subtype",
        "short" : "Event Type",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-PolicyAuditEvent-type-vs"
        }
      },
      {
        "id" : "AuditEvent.recorded",
        "path" : "AuditEvent.recorded",
        "short" : "Event Date and Time"
      },
      {
        "id" : "AuditEvent.agent",
        "path" : "AuditEvent.agent",
        "short" : "Participants"
      },
      {
        "id" : "AuditEvent.agent.role",
        "path" : "AuditEvent.agent.role",
        "short" : "role (PAT, HCP)",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-participants-vs"
        }
      },
      {
        "id" : "AuditEvent.agent.who.identifier",
        "path" : "AuditEvent.agent.who.identifier",
        "short" : "Identifier if applicable",
        "min" : 1
      },
      {
        "id" : "AuditEvent.agent.name",
        "path" : "AuditEvent.agent.name",
        "short" : "Name",
        "min" : 1
      },
      {
        "id" : "AuditEvent.agent.requestor",
        "path" : "AuditEvent.agent.requestor",
        "short" : "If participant is Initiator"
      },
      {
        "id" : "AuditEvent.entity",
        "path" : "AuditEvent.entity",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "role.code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:Patient",
        "path" : "AuditEvent.entity",
        "sliceName" : "Patient",
        "short" : "Patient",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:Patient.what.identifier",
        "path" : "AuditEvent.entity.what.identifier",
        "short" : "RID",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:Resource",
        "path" : "AuditEvent.entity",
        "sliceName" : "Resource",
        "short" : "Resource (HCP, Group)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:Resource.what.identifier",
        "path" : "AuditEvent.entity.what.identifier",
        "short" : "Identifier: KRZP for HCP"
      },
      {
        "id" : "AuditEvent.entity:Resource.role",
        "path" : "AuditEvent.entity.role",
        "short" : "role (HCP, GRP)",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-participants-vs"
        }
      }
    ]
  }
}

```
