# CZ MHD Folder Comprehensive - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ MHD Folder Comprehensive**

## Resource Profile: CZ MHD Folder Comprehensive 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-folder-comprehensive | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_Folder |

 
A profile on the List resource for MHD use as a Folder with Comprehensive Metadata 

**Usages:**

* Use this Profile: [CZ MHD Find Document Lists Comprehensive Response Message](StructureDefinition-cz-mhd-finddocumentlists-comprehensive-bundle.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-mhd-folder-comprehensive)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-mhd-folder-comprehensive.csv), [Excel](StructureDefinition-cz-mhd-folder-comprehensive.xlsx), [Schematron](StructureDefinition-cz-mhd-folder-comprehensive.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-mhd-folder-comprehensive",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-folder-comprehensive",
  "version" : "0.0.1",
  "name" : "CZ_Folder",
  "title" : "CZ MHD Folder Comprehensive",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "A profile on the List resource for MHD use as a Folder with Comprehensive Metadata",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "List",
  "baseDefinition" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.List",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "List.extension",
        "path" : "List.extension",
        "min" : 1
      },
      {
        "id" : "List.extension:designationType",
        "path" : "List.extension",
        "sliceName" : "designationType",
        "min" : 1
      },
      {
        "id" : "List.identifier",
        "path" : "List.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "use"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "List.identifier:uniqueId",
        "path" : "List.identifier",
        "sliceName" : "uniqueId",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UniqueIdIdentifier"
            ]
          }
        ]
      },
      {
        "id" : "List.identifier:entryUUID",
        "path" : "List.identifier",
        "sliceName" : "entryUUID",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.EntryUUID.Identifier"
            ]
          }
        ]
      },
      {
        "id" : "List.mode",
        "path" : "List.mode",
        "patternCode" : "working"
      },
      {
        "id" : "List.title",
        "path" : "List.title",
        "min" : 1
      },
      {
        "id" : "List.code",
        "path" : "List.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://profiles.ihe.net/ITI/MHD/CodeSystem/MHDlistTypes",
              "code" : "folder"
            }
          ]
        }
      },
      {
        "id" : "List.subject",
        "path" : "List.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "List.encounter",
        "path" : "List.encounter",
        "max" : "0"
      },
      {
        "id" : "List.source",
        "path" : "List.source",
        "max" : "0"
      },
      {
        "id" : "List.orderedBy",
        "path" : "List.orderedBy",
        "max" : "0"
      },
      {
        "id" : "List.note",
        "path" : "List.note",
        "max" : "1"
      },
      {
        "id" : "List.entry.flag",
        "path" : "List.entry.flag",
        "max" : "0"
      },
      {
        "id" : "List.entry.deleted",
        "path" : "List.entry.deleted",
        "max" : "0"
      },
      {
        "id" : "List.entry.date",
        "path" : "List.entry.date",
        "max" : "0"
      },
      {
        "id" : "List.entry.item",
        "path" : "List.entry.item",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DocumentReference"]
          }
        ]
      },
      {
        "id" : "List.emptyReason",
        "path" : "List.emptyReason",
        "max" : "0"
      }
    ]
  }
}

```
