# CZ MHD DocumentReference Comprehensive - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ MHD DocumentReference Comprehensive**

## Resource Profile: CZ MHD DocumentReference Comprehensive 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-documentreference-comprehensive | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_MhdDocumentReferenceComprehensive |

 
CZ MHD Profile on DocumentReference 

**Usages:**

* Use this Profile: [CZ MHD Find Document References Comprehensive Response message](StructureDefinition-cz-mhd-finddocumentreference-comprehensive-bundle.md) and [CZ MHD Provide Document Bundle Comprehensive](StructureDefinition-cz-mhd-providedocumentbundle-comprehensive.md)
* Refer to this Profile: [CZ MHD SubmissionSet Comprehensive](StructureDefinition-cz-mhd-submissionset-comprehensive.md)
* CapabilityStatements using this Profile: [MHD Document Consumer (client)](CapabilityStatement-CZ-MHD-DocumentConsumer.md) and [MHD Document Responder (server)](CapabilityStatement-CZ-MHD-DocumentResponder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-mhd-documentreference-comprehensive)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-mhd-documentreference-comprehensive.csv), [Excel](StructureDefinition-cz-mhd-documentreference-comprehensive.xlsx), [Schematron](StructureDefinition-cz-mhd-documentreference-comprehensive.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-mhd-documentreference-comprehensive",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-documentreference-comprehensive",
  "version" : "0.0.1",
  "name" : "CZ_MhdDocumentReferenceComprehensive",
  "title" : "CZ MHD DocumentReference Comprehensive",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ MHD Profile on DocumentReference",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "constraint" : [
          {
            "key" : "cz-mhd",
            "severity" : "error",
            "human" : "The DocumentReference needs to conform to IHE.MHD.Comprehensive.DocumentReference",
            "expression" : "conformsTo('https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.DocumentReference')",
            "source" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-mhd-documentreference-comprehensive"
          }
        ]
      },
      {
        "id" : "DocumentReference.language",
        "path" : "DocumentReference.language",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSILanguage"
        }
      },
      {
        "id" : "DocumentReference.masterIdentifier",
        "path" : "DocumentReference.masterIdentifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UniqueIdIdentifier"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "short" : "current | superseded",
        "comment" : "approved -> status=current, deprecated -> status=superseded"
      },
      {
        "id" : "DocumentReference.docStatus",
        "path" : "DocumentReference.docStatus",
        "comment" : "These HL7 FHIR elements are not used in XDS, therefore would not be present. Document Consumers should be robust to these elements holding values.",
        "max" : "0"
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-typeCode-vs"
        }
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-documentEntry-classCode-vs"
        }
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "comment" : "Not a contained resource. The identifier points to an existing patient in the XDS Affinity Domain.",
        "min" : 1
      },
      {
        "id" : "DocumentReference.subject.identifier",
        "path" : "DocumentReference.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-rid-identifier"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "comment" : "Contained resource.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-practitionerrole-core"
            ],
            "aggregation" : ["contained"]
          }
        ]
      },
      {
        "id" : "DocumentReference.authenticator",
        "path" : "DocumentReference.authenticator",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ],
            "aggregation" : ["contained"]
          }
        ]
      },
      {
        "id" : "DocumentReference.custodian",
        "path" : "DocumentReference.custodian",
        "max" : "0"
      },
      {
        "id" : "DocumentReference.relatesTo",
        "path" : "DocumentReference.relatesTo",
        "comment" : "See ITI TF-2c: 3.65.4.1.2.3"
      },
      {
        "id" : "DocumentReference.securityLabel",
        "path" : "DocumentReference.securityLabel",
        "comment" : "Note: This is NOT the DocumentReference.meta, as that holds the meta tags for the DocumentReference itself.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ConfidentialityClassification"
        }
      },
      {
        "id" : "DocumentReference.content",
        "path" : "DocumentReference.content",
        "max" : "1"
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "min" : 1
      },
      {
        "id" : "DocumentReference.content.attachment.language",
        "path" : "DocumentReference.content.attachment.language",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSILanguage"
        }
      },
      {
        "id" : "DocumentReference.content.attachment.data",
        "path" : "DocumentReference.content.attachment.data",
        "comment" : "These HL7 FHIR elements are not used in XDS, therefore would not be present. Document Consumers should be robust to these elements holding values.",
        "max" : "0"
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "short" : "The ITI-68 endpoint to use, or a reference to the Binary resource in the Bundle.",
        "comment" : "When providing the document, this URL SHALL point to the Binary resource wrapping\r\nthe document content (which SHALL be included in the Bundle). When retrieving the DocumentReference, this URL SHALL\r\nbe the the one to use in ITI-68 transactions to retrieve the document content.",
        "min" : 1
      },
      {
        "id" : "DocumentReference.content.attachment.title",
        "path" : "DocumentReference.content.attachment.title",
        "min" : 1
      },
      {
        "id" : "DocumentReference.content.attachment.creation",
        "path" : "DocumentReference.content.attachment.creation",
        "min" : 1
      },
      {
        "id" : "DocumentReference.content.format",
        "path" : "DocumentReference.content.format",
        "min" : 1
      },
      {
        "id" : "DocumentReference.context",
        "path" : "DocumentReference.context",
        "min" : 1
      },
      {
        "id" : "DocumentReference.context.facilityType",
        "path" : "DocumentReference.context.facilityType",
        "min" : 1
      },
      {
        "id" : "DocumentReference.context.practiceSetting",
        "path" : "DocumentReference.context.practiceSetting",
        "min" : 1
      },
      {
        "id" : "DocumentReference.context.sourcePatientInfo",
        "path" : "DocumentReference.context.sourcePatientInfo",
        "comment" : "Contained Patient resource with Patient.identifier.use element set to ‘usual’.\r\n\r\nIndicates that the data within the XDS document entry be represented as a contained resource. See Section 4.5.4.4.7",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.hl7cr.eu/core/StructureDefinition/cz-patient-core"
            ],
            "aggregation" : ["contained"]
          }
        ]
      },
      {
        "id" : "DocumentReference.context.related",
        "path" : "DocumentReference.context.related",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "identifier"
            }
          ],
          "rules" : "open"
        },
        "comment" : "May be filled with URL pointers to Resources or Identifiers found in referenceIdList"
      },
      {
        "id" : "DocumentReference.context.related:StudyInstanceUID",
        "path" : "DocumentReference.context.related",
        "sliceName" : "StudyInstanceUID",
        "min" : 0,
        "max" : "1"
      }
    ]
  }
}

```
