# CZ Audit Event for [ITI-66] Document List Consumer - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Audit Event for [ITI-66] Document List Consumer**

## Resource Profile: CZ Audit Event for [ITI-66] Document List Consumer 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti66Consumer | *Version*:0.0.1 |
| Draft as of 2025-10-14 | *Computable Name*:CZ_AuditEventIti66Consumer |

 
This profile is used to define the CZ Audit Event for the [ITI-66] transaction and the actor 'Document list Consumer'. 

**Usages:**

* Examples for this Profile: [AuditEvent/CZ-AuditEventIti66ConsumerExample](AuditEvent-CZ-AuditEventIti66ConsumerExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hie|current/StructureDefinition/cz-auditEventIti66Consumer)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-auditEventIti66Consumer.csv), [Excel](StructureDefinition-cz-auditEventIti66Consumer.xlsx), [Schematron](StructureDefinition-cz-auditEventIti66Consumer.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-auditEventIti66Consumer",
  "url" : "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti66Consumer",
  "version" : "0.0.1",
  "name" : "CZ_AuditEventIti66Consumer",
  "title" : "CZ Audit Event for [ITI-66] Document List Consumer",
  "status" : "draft",
  "date" : "2025-10-14T14:33:28+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile is used to define the CZ Audit Event for the [ITI-66] transaction and the actor 'Document list\r\nConsumer'.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "fhirprovenance",
      "uri" : "http://hl7.org/fhir/provenance",
      "name" : "FHIR Provenance Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AuditEvent",
  "baseDefinition" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentLists.Audit.Consumer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AuditEvent",
        "path" : "AuditEvent"
      },
      {
        "id" : "AuditEvent.agent",
        "path" : "AuditEvent.agent",
        "min" : 3
      },
      {
        "id" : "AuditEvent.agent:client",
        "path" : "AuditEvent.agent",
        "sliceName" : "client",
        "short" : "The 'Document List Consumer' actor (Client application)"
      },
      {
        "id" : "AuditEvent.agent:server",
        "path" : "AuditEvent.agent",
        "sliceName" : "server",
        "short" : "The 'Document List Responder' actor (Server API)"
      },
      {
        "id" : "AuditEvent.agent:mainUser",
        "path" : "AuditEvent.agent",
        "sliceName" : "mainUser",
        "short" : "The main user (patient, representative, healthcare professional, or administrator)",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.agent:mainUser.type",
        "path" : "AuditEvent.agent.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "RESP",
              "display" : "responsible party"
            }
          ]
        }
      },
      {
        "id" : "AuditEvent.agent:mainUser.role",
        "path" : "AuditEvent.agent.role",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.agent:mainUser.altId",
        "path" : "AuditEvent.agent.altId",
        "min" : 1
      },
      {
        "id" : "AuditEvent.agent:mainUser.name",
        "path" : "AuditEvent.agent.name",
        "min" : 1
      },
      {
        "id" : "AuditEvent.agent:mainUser.purposeOfUse",
        "path" : "AuditEvent.agent.purposeOfUse",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/hie/ValueSet/cz-purposeOfUse-vs"
        }
      },
      {
        "id" : "AuditEvent.agent:delegatedUser",
        "path" : "AuditEvent.agent",
        "sliceName" : "delegatedUser",
        "short" : "The person who acted on behalf of the main user (an assistant or technical user)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.agent:delegatedUser.type",
        "path" : "AuditEvent.agent.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF",
              "display" : "primary performer"
            }
          ]
        }
      },
      {
        "id" : "AuditEvent.agent:delegatedUser.role",
        "path" : "AuditEvent.agent.role",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.agent:delegatedUser.altId",
        "path" : "AuditEvent.agent.altId",
        "min" : 1
      },
      {
        "id" : "AuditEvent.agent:delegatedUser.name",
        "path" : "AuditEvent.agent.name",
        "min" : 1
      },
      {
        "id" : "AuditEvent.source.site",
        "path" : "AuditEvent.source.site",
        "short" : "The OID of the audit source",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:patient",
        "path" : "AuditEvent.entity",
        "sliceName" : "patient"
      },
      {
        "id" : "AuditEvent.entity:patient.what.identifier",
        "path" : "AuditEvent.entity.what.identifier",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:patient.what.identifier.system",
        "path" : "AuditEvent.entity.what.identifier.system",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:patient.what.identifier.value",
        "path" : "AuditEvent.entity.what.identifier.value",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:traceparent",
        "path" : "AuditEvent.entity",
        "sliceName" : "traceparent",
        "short" : "The 'traceparent' header value of the transaction",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "AuditEvent.entity:traceparent.what",
        "path" : "AuditEvent.entity.what",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:traceparent.what.identifier",
        "path" : "AuditEvent.entity.what.identifier",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:traceparent.what.identifier.value",
        "path" : "AuditEvent.entity.what.identifier.value",
        "short" : "The 'traceparent' header value",
        "min" : 1
      },
      {
        "id" : "AuditEvent.entity:traceparent.type",
        "path" : "AuditEvent.entity.type",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
          "code" : "4",
          "display" : "Other"
        }
      },
      {
        "id" : "AuditEvent.entity:traceparent.role",
        "path" : "AuditEvent.entity.role",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/object-role",
          "code" : "26",
          "display" : "Processing Element"
        }
      }
    ]
  }
}

```
