# CZ DocumentEntry TypeCode CodeSystem - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ DocumentEntry TypeCode CodeSystem**

## CodeSystem: CZ DocumentEntry TypeCode CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-typeCode-cs | *Version*:0.0.1 |
| Active as of 2025-01-17 | *Computable Name*:CZ_DocumentEntryTypeCodeCs |

 
Codesystem for document type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CZ_DocumentEntryTypeCodeVs](ValueSet-cz-documentEntry-typeCode-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-documentEntry-typeCode-cs",
  "language" : "cs-CZ",
  "url" : "https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-typeCode-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_DocumentEntryTypeCodeCs",
  "title" : "CZ DocumentEntry TypeCode CodeSystem",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-17",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Codesystem for document type codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 11,
  "concept" : [
    {
      "code" : "01",
      "display" : "Propouštěcí zpráva z nemocnice"
    },
    {
      "code" : "02",
      "display" : "Zpráva z laboratorního vyšetření"
    },
    {
      "code" : "03",
      "display" : "Zpráva z obrazového vyšetření"
    },
    {
      "code" : "04",
      "display" : "Pacientský souhrn"
    },
    {
      "code" : "05",
      "display" : "Žádanka na obrazové vyšetření"
    },
    {
      "code" : "06",
      "display" : "Laboratorní žádanka"
    },
    {
      "code" : "07",
      "display" : "Ambulantní zpráva"
    },
    {
      "code" : "08",
      "display" : "Objednávka laboratorního vyšetření"
    },
    {
      "code" : "09",
      "display" : "Objednávka obrazového vyšetření"
    },
    {
      "code" : "10",
      "display" : "Záznam o výjezdu zdravotnické záchranné služby"
    },
    {
      "code" : "11",
      "display" : "Hlášení výsledků laboratorních vyšetření do NZIS"
    }
  ]
}

```
