# ATNA Audit Creator (client) - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ATNA Audit Creator (client)**

## CapabilityStatement: ATNA Audit Creator (client) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hie/CapabilityStatement/CZ-ATNA-AuditCreator | *Version*:0.0.1 |
| Active as of 2024-01-08 | *Computable Name*:CZ_ATNA_Audit_Creator |

 
CapabilityStatement for Client Actor in the IHE IT Infrastructure Technical Framework Supplement Add RESTful ATNA. 

 [Raw OpenAPI-Swagger Definition file](CZ-ATNA-AuditCreator.openapi.json) | [Download](CZ-ATNA-AuditCreator.openapi.json) 

## ATNA Audit Creator (client)

* Implementation Guide Version: 0.0.1 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2024-01-08 
* Published by: HL7 Czech Republic 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: client

IHE ITI ATNA ITI-20 endpoint

**Summary of System-wide Interactions**

* Supports the `batch`interaction described as follows:

ITI-20 Send Audit Bundle Request Message - FHIR Feed Interaction


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AuditEvent](#AuditEvent1-1) | Supported Profiles  [CZ Audit Event for [ITI-65] Document Recipient](StructureDefinition-cz-auditEventIti65Recipient.md)  [CZ Audit Event for [ITI-65] Document Source](StructureDefinition-cz-auditEventIti65Source.md)  [CZ Audit Event for [ITI-67] Document Consumer](StructureDefinition-cz-auditEventIti67Consumer.md)  [CZ Audit Event for [ITI-67] Document Responder](StructureDefinition-cz-auditEventIti67Responder.md)  [CZ Audit Event for [ITI-68] Document Consumer](StructureDefinition-cz-auditEventIti68Consumer.md) |  |  |  | y |  |  |  |  |

-------

#### Resource Conformance: supported AuditEvent

Core FHIR Resource

[AuditEvent](http://hl7.org/fhir/R4/auditevent.html)

Reference Policy

Interaction summary

* Supports `create`.

Supported Profiles
[CZ Audit Event for [ITI-65] Document Recipient](StructureDefinition-cz-auditEventIti65Recipient.md)
[CZ Audit Event for [ITI-65] Document Source](StructureDefinition-cz-auditEventIti65Source.md)
[CZ Audit Event for [ITI-67] Document Consumer](StructureDefinition-cz-auditEventIti67Consumer.md)
[CZ Audit Event for [ITI-67] Document Responder](StructureDefinition-cz-auditEventIti67Responder.md)
[CZ Audit Event for [ITI-68] Document Consumer](StructureDefinition-cz-auditEventIti68Consumer.md)



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "CZ-ATNA-AuditCreator",
  "url" : "https://hl7.cz/fhir/hie/CapabilityStatement/CZ-ATNA-AuditCreator",
  "version" : "0.0.1",
  "name" : "CZ_ATNA_Audit_Creator",
  "title" : "ATNA Audit Creator (client)",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-08",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CapabilityStatement for Client Actor in the IHE IT Infrastructure Technical Framework Supplement Add RESTful ATNA.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "IHE ITI ATNA ITI-20 endpoint",
      "resource" : [
        {
          "type" : "AuditEvent",
          "supportedProfile" : [
            "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti65Recipient",
            "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti65Source",
            "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti67Consumer",
            "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti67Responder",
            "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti68Consumer"
          ],
          "interaction" : [
            {
              "code" : "create"
            }
          ],
          "versioning" : "no-version"
        }
      ],
      "interaction" : [
        {
          "code" : "batch",
          "documentation" : "ITI-20 Send Audit Bundle Request Message - FHIR Feed Interaction"
        }
      ]
    }
  ]
}

```
