# CZ-AuditEventIti68ResponderExample - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-AuditEventIti68ResponderExample**

## Example AuditEvent: CZ-AuditEventIti68ResponderExample

Profile: [CZ Audit Event for [ITI-68] Document Responder](StructureDefinition-cz-auditEventIti68Responder.md)

**type**: [Audit Event ID rest](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-type.html#audit-event-type-rest): RESTful Operation

**subtype**: unknown ITI-68: Retrieve Document, [FHIR Restful Interactions read](http://hl7.org/fhir/R4/codesystem-restful-interaction.html#restful-interaction-read): read

**recorded**: 2024-10-28 09:43:56+0000

**outcome**: Success

> **agent****type**:Destination Role ID**who**: Portal**requestor**: false

### Networks

| | | |
| :--- | :--- | :--- |
| - | **Address** | **Type** |
| * | 192.168.1.1 | IP Address |


> **agent****type**:Source Role ID**who**: Affinitní doména A**requestor**: false

### Networks

| | | |
| :--- | :--- | :--- |
| - | **Address** | **Type** |
| * | https://example.org/blah/blah.pdf | URI |


> **agent****type**:responsible party**role**:Healthcare professional**altId**: 2000000090092**name**: Mracena Mrakomorová**requestor**: true**purposeOfUse**:Normální přístup

### Sources

| | | |
| :--- | :--- | :--- |
| - | **Site** | **Observer** |
| * | 2.16.756.4.5.6 | Affinitní doména A |

> **entity****what**:[https://example.org/blah/blah.pdf](https://example.org/blah/blah.pdf)**type**:[Audit event entity type 2](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-2): System Object**role**:[AuditEventEntityRole 3](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-3): Report

> **entity****what**: Identifier:`https://ncez.mzcr.cz/fhir/sid/rid`/4567891235**type**:[Audit event entity type 1](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-1): Person**role**:[AuditEventEntityRole 1](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-1): Patient

> **entity****what**: Identifier: 00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00**type**:[Audit event entity type 4](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-4): Other**role**:[AuditEventEntityRole 26](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-26): Processing Element



## Resource Content

```json
{
  "resourceType" : "AuditEvent",
  "id" : "CZ-AuditEventIti68ResponderExample",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti68Responder"
    ]
  },
  "type" : {
    "system" : "http://terminology.hl7.org/CodeSystem/audit-event-type",
    "code" : "rest"
  },
  "subtype" : [
    {
      "system" : "urn:ihe:event-type-code",
      "code" : "ITI-68",
      "display" : "Retrieve Document"
    },
    {
      "system" : "http://hl7.org/fhir/restful-interaction",
      "code" : "read",
      "display" : "read"
    }
  ],
  "recorded" : "2024-10-28T09:43:56Z",
  "outcome" : "0",
  "agent" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "code" : "110152",
            "display" : "Destination Role ID"
          }
        ]
      },
      "who" : {
        "display" : "Portal"
      },
      "requestor" : false,
      "network" : {
        "address" : "192.168.1.1",
        "type" : "2"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "code" : "110153",
            "display" : "Source Role ID"
          }
        ]
      },
      "who" : {
        "display" : "Affinitní doména A"
      },
      "requestor" : false,
      "network" : {
        "address" : "https://example.org/blah/blah.pdf",
        "type" : "5"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
            "code" : "RESP",
            "display" : "responsible party"
          }
        ]
      },
      "role" : [
        {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs",
              "code" : "HCP"
            }
          ]
        }
      ],
      "altId" : "2000000090092",
      "name" : "Mracena Mrakomorová",
      "requestor" : true,
      "purposeOfUse" : [
        {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-purposeOfUse-cs",
              "code" : "NORM",
              "display" : "Normální přístup"
            }
          ]
        }
      ]
    }
  ],
  "source" : {
    "site" : "2.16.756.4.5.6",
    "observer" : {
      "display" : "Affinitní doména A"
    }
  },
  "entity" : [
    {
      "what" : {
        "reference" : "https://example.org/blah/blah.pdf"
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "2",
        "display" : "System Object"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "3",
        "display" : "Report"
      }
    },
    {
      "what" : {
        "identifier" : {
          "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
          "value" : "4567891235"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "1",
        "display" : "Person"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "1",
        "display" : "Patient"
      }
    },
    {
      "what" : {
        "identifier" : {
          "value" : "00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "4",
        "display" : "Other"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "26",
        "display" : "Processing Element"
      }
    }
  ]
}

```
