# CZ-AuditEventIti67ConsumerExample - HL7 Czech Health information exchange Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-AuditEventIti67ConsumerExample**

## Example AuditEvent: CZ-AuditEventIti67ConsumerExample

Profile: [CZ Audit Event for [ITI-67] Document Consumer](StructureDefinition-cz-auditEventIti67Consumer.md)

**type**: [Audit Event ID rest](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-type.html#audit-event-type-rest): RESTful Operation

**subtype**: unknown ITI-67: Find Document References, [FHIR Restful Interactions search](http://hl7.org/fhir/R4/codesystem-restful-interaction.html#restful-interaction-search): search

**recorded**: 2024-10-28 09:43:56+0000

**outcome**: Success

> **agent****type**:Source Role ID**who**: Affinitní doména A**requestor**: false

### Networks

| | | |
| :--- | :--- | :--- |
| - | **Address** | **Type** |
| * | 192.168.1.1 | IP Address |


> **agent****type**:Destination Role ID**who**: Nemocnice XYZ**requestor**: false

### Networks

| | | |
| :--- | :--- | :--- |
| - | **Address** | **Type** |
| * | https://example.com | URI |


> **agent****type**:responsible party**role**:Healthcare professional**altId**: 2000000090092**name**: Mračena Mrakomorová**requestor**: true**purposeOfUse**:Normální přístup

### Sources

| | | |
| :--- | :--- | :--- |
| - | **Site** | **Observer** |
| * | 2.16.756.4.5.6 | Affinitní doména A |

> **entity****type**:[Audit event entity type 2](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-2): System Object**role**:[AuditEventEntityRole 24](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-24): Query**query**:`aHR0cDovL2V4YW1wbGUuY29tL2ZoaXIvRG9jdW1lbnRSZWZlcmVuY2U/cGF0aWVudC5pZGVudGlmaWVyPXVybjpvaWQ6Mi4xNi43NTYuNS4zMC4xLjEyNy4zLjEwLjN8NzYxMzM3NjEwNDExMzUzNjUwJnN0YXR1cz1jdXJyZW50`

> **entity****what**: Identifier:`https://ncez.mzcr.cz/fhir/sid/rid`/4567891235**type**:[Audit event entity type 1](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-1): Person**role**:[AuditEventEntityRole 1](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-1): Patient

> **entity****what**: Identifier: 00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00**type**:[Audit event entity type 4](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html#audit-entity-type-4): Other**role**:[AuditEventEntityRole 26](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html#object-role-26): Processing Element



## Resource Content

```json
{
  "resourceType" : "AuditEvent",
  "id" : "CZ-AuditEventIti67ConsumerExample",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hie/StructureDefinition/cz-auditEventIti67Consumer"
    ]
  },
  "type" : {
    "system" : "http://terminology.hl7.org/CodeSystem/audit-event-type",
    "code" : "rest"
  },
  "subtype" : [
    {
      "system" : "urn:ihe:event-type-code",
      "code" : "ITI-67",
      "display" : "Find Document References"
    },
    {
      "system" : "http://hl7.org/fhir/restful-interaction",
      "code" : "search",
      "display" : "search"
    }
  ],
  "recorded" : "2024-10-28T09:43:56Z",
  "outcome" : "0",
  "agent" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "code" : "110153",
            "display" : "Source Role ID"
          }
        ]
      },
      "who" : {
        "display" : "Affinitní doména A"
      },
      "requestor" : false,
      "network" : {
        "address" : "192.168.1.1",
        "type" : "2"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "code" : "110152",
            "display" : "Destination Role ID"
          }
        ]
      },
      "who" : {
        "display" : "Nemocnice XYZ"
      },
      "requestor" : false,
      "network" : {
        "address" : "https://example.com",
        "type" : "5"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
            "code" : "RESP",
            "display" : "responsible party"
          }
        ]
      },
      "role" : [
        {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-documentEntry-authorRole-cs",
              "code" : "HCP"
            }
          ]
        }
      ],
      "altId" : "2000000090092",
      "name" : "Mračena Mrakomorová",
      "requestor" : true,
      "purposeOfUse" : [
        {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/hie/CodeSystem/cz-purposeOfUse-cs",
              "code" : "NORM",
              "display" : "Normální přístup"
            }
          ]
        }
      ]
    }
  ],
  "source" : {
    "site" : "2.16.756.4.5.6",
    "observer" : {
      "display" : "Affinitní doména A"
    }
  },
  "entity" : [
    {
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "2",
        "display" : "System Object"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "24",
        "display" : "Query"
      },
      "query" : "aHR0cDovL2V4YW1wbGUuY29tL2ZoaXIvRG9jdW1lbnRSZWZlcmVuY2U/cGF0aWVudC5pZGVudGlmaWVyPXVybjpvaWQ6Mi4xNi43NTYuNS4zMC4xLjEyNy4zLjEwLjN8NzYxMzM3NjEwNDExMzUzNjUwJnN0YXR1cz1jdXJyZW50"
    },
    {
      "what" : {
        "identifier" : {
          "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
          "value" : "4567891235"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "1",
        "display" : "Person"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "1",
        "display" : "Patient"
      }
    },
    {
      "what" : {
        "identifier" : {
          "value" : "00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00"
        }
      },
      "type" : {
        "system" : "http://terminology.hl7.org/CodeSystem/audit-entity-type",
        "code" : "4",
        "display" : "Other"
      },
      "role" : {
        "system" : "http://terminology.hl7.org/CodeSystem/object-role",
        "code" : "26",
        "display" : "Processing Element"
      }
    }
  ]
}

```
